/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.util;

import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerFieldUpdaterCustomizer<S, T>
implements ServiceTrackerCustomizer<S, T> {
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final T _dummyTrackedService;
    private final Field _serviceField;
    private final Reference<?> _serviceHolderReference;
    private final Map<ServiceReference<S>, T> _trackedServices = new ConcurrentHashMap<ServiceReference<S>, T>();

    public ServiceTrackerFieldUpdaterCustomizer(Field serviceField, Object serviceHolder, T dummyTrackedService) {
        if (!Modifier.isVolatile(serviceField.getModifiers())) {
            throw new IllegalArgumentException(serviceField + " is not volatile");
        }
        this._serviceField = serviceField;
        this._serviceHolderReference = serviceHolder == null ? null : new WeakReference<Object>(serviceHolder);
        this._dummyTrackedService = dummyTrackedService;
    }

    public final T addingService(ServiceReference<S> serviceReference) {
        T trackedService = this.doAddingService(serviceReference);
        if (trackedService != null) {
            this._trackedServices.put(serviceReference, trackedService);
            this._updateService();
        }
        return trackedService;
    }

    public final void modifiedService(ServiceReference<S> serviceReference, T service) {
        this.doModifiedService(serviceReference, service);
        this._updateService();
    }

    public final void removedService(ServiceReference<S> serviceReference, T service) {
        if (this._trackedServices.remove(serviceReference, service)) {
            this._updateService();
        }
        this.doRemovedService(serviceReference, service);
    }

    protected void afterServiceUpdate(T oldService, T newService) {
    }

    protected void beforeServiceUpdate(T oldService, T newService) {
    }

    protected T doAddingService(ServiceReference<S> serviceReference) {
        return (T)this._bundleContext.getService(serviceReference);
    }

    protected void doModifiedService(ServiceReference<S> serviceReference, T service) {
    }

    protected void doRemovedService(ServiceReference<S> serviceReference, T service) {
        this._bundleContext.ungetService(serviceReference);
    }

    protected void doServiceUpdate(T newService) {
        Object serviceHolder = null;
        if (this._serviceHolderReference != null && (serviceHolder = this._serviceHolderReference.get()) == null) {
            return;
        }
        try {
            Object oldService = this._serviceField.get(serviceHolder);
            if (newService != oldService) {
                this.beforeServiceUpdate(oldService, newService);
                this._serviceField.set(serviceHolder, newService);
                this.afterServiceUpdate(oldService, newService);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private void _updateService() {
        Object service = this._dummyTrackedService;
        Set<Map.Entry<ServiceReference<S>, T>> entrySet = this._trackedServices.entrySet();
        Map.Entry<ServiceReference<S>, T> maxEntry = null;
        for (Map.Entry<ServiceReference<S>, T> entry : entrySet) {
            if (maxEntry == null) {
                maxEntry = entry;
                continue;
            }
            ServiceReference<S> serviceReference = entry.getKey();
            if (serviceReference.compareTo(maxEntry.getKey()) <= 0) continue;
            maxEntry = entry;
        }
        if (maxEntry != null) {
            service = maxEntry.getValue();
        }
        this.doServiceUpdate(service);
    }
}

