/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class DefaultFriendlyURLMapper
extends BaseFriendlyURLMapper {
    protected Set<String> defaultIgnoredParameters = new LinkedHashSet<String>();
    protected Map<String, String> defaultReservedParameters;
    private static final Log _log = LogFactoryUtil.getLog(DefaultFriendlyURLMapper.class);

    public DefaultFriendlyURLMapper() {
        this.defaultIgnoredParameters.add("p_p_id");
        this.defaultReservedParameters = LinkedHashMapBuilder.put("p_p_lifecycle", "0").put("p_p_state", WindowState.NORMAL.toString()).put("p_p_mode", PortletMode.VIEW.toString()).build();
    }

    public void addDefaultIgnoredParameter(String name) {
        this.defaultIgnoredParameters.add(name);
    }

    public void addDefaultReservedParameter(String name, String value) {
        this.defaultReservedParameters.put(name, value);
    }

    @Override
    public String buildPath(LiferayPortletURL liferayPortletURL) {
        HashMap<String, String> routeParameters = new HashMap<String, String>();
        this.buildRouteParameters(liferayPortletURL, routeParameters);
        String friendlyURLPath = this.router.parametersToUrl(routeParameters);
        if (Validator.isNull(friendlyURLPath)) {
            return null;
        }
        this.addParametersIncludedInPath(liferayPortletURL, routeParameters);
        return StringBundler.concat((String[])new String[]{"/", this.getMapping(), friendlyURLPath});
    }

    public Set<String> getDefaultIgnoredParameters() {
        return this.defaultIgnoredParameters;
    }

    public Map<String, String> getDefaultReservedParameters() {
        return this.defaultReservedParameters;
    }

    @Override
    public void populateParams(String friendlyURLPath, Map<String, String[]> parameterMap, Map<String, Object> requestContext) {
        HashMap<String, String> routeParameters;
        String mapping = this.getMapping();
        if ((friendlyURLPath = friendlyURLPath.substring(mapping.length() + 1)).endsWith("/")) {
            friendlyURLPath = friendlyURLPath.substring(0, friendlyURLPath.length() - 1);
        }
        if (!this.router.urlToParameters(friendlyURLPath, routeParameters = new HashMap<String, String>())) {
            if (_log.isWarnEnabled()) {
                _log.warn("No route could be found to match URL " + friendlyURLPath);
            }
            return;
        }
        String namespace = null;
        String portletInstanceKey = this.getPortletInstanceKey(routeParameters);
        if (Validator.isNotNull(portletInstanceKey)) {
            namespace = PortalUtil.getPortletNamespace(portletInstanceKey);
            this.addParameter(namespace, parameterMap, "p_p_id", portletInstanceKey);
        } else if (this.isAllPublicRenderParameters(routeParameters)) {
            this.addParameter(null, parameterMap, "p_p_id", this.getPortletId());
        } else {
            return;
        }
        this.populateParams(parameterMap, namespace, routeParameters);
    }

    protected void addParametersIncludedInPath(LiferayPortletURL liferayPortletURL, Map<String, String> routeParameters) {
        for (String name : this.defaultIgnoredParameters) {
            liferayPortletURL.addParameterIncludedInPath(name);
        }
        Map portletURLParameters = liferayPortletURL.getParameterMap();
        for (String name : portletURLParameters.keySet()) {
            if (routeParameters.containsKey(name)) continue;
            liferayPortletURL.addParameterIncludedInPath(name);
        }
        liferayPortletURL.visitReservedParameters((key, value) -> {
            if (!routeParameters.containsKey(key) || value.equals(this.defaultReservedParameters.get(key))) {
                liferayPortletURL.addParameterIncludedInPath((String)key);
            }
        });
    }

    protected void buildRouteParameters(LiferayPortletURL liferayPortletURL, Map<String, String> routeParameters) {
        Map portletURLParameters = liferayPortletURL.getParameterMap();
        for (Map.Entry entry : portletURLParameters.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length <= 0) continue;
            routeParameters.put((String)entry.getKey(), values[0]);
        }
        String portletInstanceKey = liferayPortletURL.getPortletId();
        if (Validator.isNotNull(portletInstanceKey)) {
            routeParameters.put("p_p_id", portletInstanceKey);
            long userId = PortletIdCodec.decodeUserId(portletInstanceKey);
            String instanceId = PortletIdCodec.decodeInstanceId(portletInstanceKey);
            routeParameters.put("userIdAndInstanceId", PortletIdCodec.encodeUserIdAndInstanceId(userId, instanceId));
            if (instanceId != null) {
                routeParameters.put("instanceId", instanceId);
            }
        }
        liferayPortletURL.visitReservedParameters(routeParameters::put);
    }

    protected String getPortletInstanceKey(Map<String, String> routeParameters) {
        String userIdAndInstanceId = routeParameters.remove("userIdAndInstanceId");
        if (!this.isPortletInstanceable() && Validator.isNull(userIdAndInstanceId)) {
            return this.getPortletId();
        }
        String portletInstanceKey = routeParameters.remove("p_p_id");
        if (Validator.isNotNull(portletInstanceKey)) {
            return portletInstanceKey;
        }
        if (Validator.isNotNull(userIdAndInstanceId)) {
            PortletIdCodec.validatePortletName(this.getPortletId());
            ObjectValuePair<Long, String> objectValuePair = PortletIdCodec.decodeUserIdAndInstanceId(userIdAndInstanceId);
            return PortletIdCodec.encode(this.getPortletId(), objectValuePair.getKey(), objectValuePair.getValue());
        }
        String instanceId = routeParameters.remove("instanceId");
        if (Validator.isNotNull(instanceId)) {
            PortletIdCodec.validatePortletName(this.getPortletId());
            return PortletIdCodec.encode(this.getPortletId(), instanceId);
        }
        if (!this.isAllPublicRenderParameters(routeParameters)) {
            _log.error("Either p_p_id or instanceId must be provided for an instanceable portlet");
        }
        return null;
    }

    protected boolean isAllPublicRenderParameters(Map<String, String> routeParameters) {
        Set<String> routeParameterKeys = routeParameters.keySet();
        Map<String, String> publicRenderParameters = FriendlyURLMapperThreadLocal.getPRPIdentifiers();
        return routeParameterKeys.containsAll(publicRenderParameters.keySet());
    }

    protected void populateParams(Map<String, String[]> parameterMap, String namespace, Map<String, String> routeParameters) {
        for (Map.Entry<String, String> entry : routeParameters.entrySet()) {
            this.addParameter(namespace, parameterMap, entry.getKey(), entry.getValue());
        }
        Map<String, Object> parentParameterMap = FriendlyURLMapperThreadLocal.getParentParameters();
        if (parentParameterMap == null) {
            parentParameterMap = Collections.emptyMap();
        }
        for (Map.Entry<String, String> entry : this.defaultReservedParameters.entrySet()) {
            String key = entry.getKey();
            if (parameterMap.containsKey(key)) continue;
            this.addParameter(namespace, parameterMap, key, MapUtil.getString(parentParameterMap, key, entry.getValue()));
        }
    }
}

