/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.TempAttributesServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.Event;
import javax.portlet.MimeResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

public class PortletContainerUtil {
    private static final boolean _PORTLET_CONTAINER_RESTRICT = GetterUtil.getBoolean(PropsUtil.get("portlet.container.restrict"));
    private static final boolean _PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET = !StringUtil.equalsIgnoreCase(PropsUtil.get("portlet.event.distribution"), "layout");
    private static PortletContainer _portletContainer;

    public static List<LayoutTypePortlet> getLayoutTypePortlets(Layout layout) throws PortletContainerException {
        if (_PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET) {
            List<Layout> layouts = null;
            try {
                layouts = LayoutLocalServiceUtil.getLayouts(layout.getGroupId(), layout.isPrivateLayout(), "portlet");
            }
            catch (PortalException portalException) {
                throw new PortletContainerException(portalException);
            }
            ArrayList<LayoutTypePortlet> layoutTypePortlets = new ArrayList<LayoutTypePortlet>(layouts.size());
            for (Layout curLayout : layouts) {
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)curLayout.getLayoutType();
                layoutTypePortlets.add(layoutTypePortlet);
            }
            return layoutTypePortlets;
        }
        if (layout.isTypePortlet()) {
            ArrayList<LayoutTypePortlet> layoutTypePortlets = new ArrayList<LayoutTypePortlet>(1);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlets.add(layoutTypePortlet);
            return layoutTypePortlets;
        }
        return Collections.emptyList();
    }

    public static PortletContainer getPortletContainer() {
        return _portletContainer;
    }

    public static void preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws PortletContainerException {
        _portletContainer.preparePortlet(httpServletRequest, portlet);
    }

    public static void processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        List<Event> events;
        PortletContainer portletContainer = _portletContainer;
        ActionResult actionResult = portletContainer.processAction(httpServletRequest, httpServletResponse, portlet);
        String location = actionResult.getLocation();
        if ((_PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET || portlet.isActionURLRedirect() || Validator.isNull(location)) && !(events = actionResult.getEvents()).isEmpty()) {
            PortletContainerUtil._processEvents(httpServletRequest, httpServletResponse, events);
        }
        if (Validator.isNull(location) || httpServletResponse.isCommitted()) {
            return;
        }
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.getSpecMajorVersion() >= 3 && portlet.isActionURLRedirect()) {
            Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create(httpServletRequest, portlet, layout, "RENDER_PHASE", MimeResponse.Copy.ALL);
            try {
                URL locationURL = new URL(location);
                URL renderURL = new URL(liferayPortletURL.toString());
                String protocol = locationURL.getProtocol();
                String host = locationURL.getHost();
                int port = locationURL.getPort();
                if (protocol.equals(renderURL.getProtocol()) && host.equals(renderURL.getHost()) && port == renderURL.getPort() && PortletContainerUtil._hasSamePortletIdParameter(locationURL.getQuery(), renderURL.getQuery())) {
                    location = liferayPortletURL.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new PortletContainerException(malformedURLException);
            }
        }
        try {
            httpServletResponse.sendRedirect(location);
        }
        catch (IOException ioException) {
            throw new PortletContainerException(ioException);
        }
    }

    public static void processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        PortletContainer portletContainer = _portletContainer;
        List<Event> events = portletContainer.processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
        if (!events.isEmpty()) {
            PortletContainerUtil._processEvents(httpServletRequest, httpServletResponse, events);
        }
    }

    public static void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout) {
        _portletContainer.processPublicRenderParameters(httpServletRequest, layout);
    }

    public static void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        _portletContainer.processPublicRenderParameters(httpServletRequest, layout, portlet);
    }

    public static void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        _portletContainer.render(httpServletRequest, httpServletResponse, portlet);
    }

    public static void renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        _portletContainer.renderHeaders(httpServletRequest, httpServletResponse, portlet);
    }

    public static void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        _portletContainer.serveResource(httpServletRequest, httpServletResponse, portlet);
    }

    public static HttpServletRequest setupOptionalRenderParameters(HttpServletRequest httpServletRequest, String renderPath, String columnId, Integer columnPos, Integer columnCount) {
        return PortletContainerUtil.setupOptionalRenderParameters(httpServletRequest, renderPath, columnId, columnPos, columnCount, null, null);
    }

    public static HttpServletRequest setupOptionalRenderParameters(HttpServletRequest httpServletRequest, String renderPath, String columnId, Integer columnPos, Integer columnCount, Boolean boundary, Boolean decorate) {
        if (_PORTLET_CONTAINER_RESTRICT) {
            RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(httpServletRequest);
            if (renderPath != null) {
                restrictPortletServletRequest.setAttribute("RENDER_PATH", renderPath);
            }
            if (columnId != null) {
                restrictPortletServletRequest.setAttribute("RENDER_PORTLET_COLUMN_ID", columnId);
            }
            if (columnPos != null) {
                restrictPortletServletRequest.setAttribute("RENDER_PORTLET_COLUMN_POS", columnPos);
            }
            if (columnCount != null) {
                restrictPortletServletRequest.setAttribute("RENDER_PORTLET_COLUMN_COUNT", columnCount);
            }
            if (boundary != null) {
                restrictPortletServletRequest.setAttribute("RENDER_PORTLET_BOUNDARY", boundary);
            }
            if (decorate != null) {
                restrictPortletServletRequest.setAttribute("PORTLET_DECORATE", decorate);
            }
            return restrictPortletServletRequest;
        }
        TempAttributesServletRequest tempAttributesServletRequest = new TempAttributesServletRequest(httpServletRequest);
        if (renderPath != null) {
            tempAttributesServletRequest.setTempAttribute("RENDER_PATH", renderPath);
        }
        if (columnId != null) {
            tempAttributesServletRequest.setTempAttribute("RENDER_PORTLET_COLUMN_ID", columnId);
        }
        if (columnPos != null) {
            tempAttributesServletRequest.setTempAttribute("RENDER_PORTLET_COLUMN_POS", columnPos);
        }
        if (columnCount != null) {
            tempAttributesServletRequest.setTempAttribute("RENDER_PORTLET_COLUMN_COUNT", columnCount);
        }
        return tempAttributesServletRequest;
    }

    public void setPortletContainer(PortletContainer portletContainer) {
        _portletContainer = portletContainer;
    }

    private static boolean _hasSamePortletIdParameter(String queryString1, String queryString2) {
        int length;
        int y2;
        if (queryString1 == null || queryString2 == null) {
            return false;
        }
        int x1 = queryString1.indexOf("p_p_id=");
        if (x1 < 0) {
            return false;
        }
        int x2 = queryString2.indexOf("p_p_id=");
        if (x2 < 0) {
            return false;
        }
        x2 += 7;
        int y1 = queryString1.indexOf(38, x1 += 7);
        if (y1 < 0) {
            y1 = queryString1.length();
        }
        if ((y2 = (length = y1 - x1) + x2) > queryString2.length() || y2 != queryString2.length() && queryString2.charAt(y2) != '&') {
            return false;
        }
        return queryString1.regionMatches(x1, queryString2, x2, length);
    }

    private static void _processEvents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, List<Event> events) throws PortletContainerException {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        List<LayoutTypePortlet> layoutTypePortlets = PortletContainerUtil.getLayoutTypePortlets(layout);
        for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
            List<Portlet> portlets = null;
            try {
                portlets = layoutTypePortlet.getAllPortlets();
            }
            catch (Exception exception) {
                throw new PortletContainerException(exception);
            }
            for (Portlet portlet : portlets) {
                for (Event event : events) {
                    QName qName = event.getQName();
                    com.liferay.portal.kernel.xml.QName processingQName = portlet.getProcessingEvent(qName.getNamespaceURI(), qName.getLocalPart());
                    if (processingQName == null) continue;
                    PortletContainerUtil.processEvent(httpServletRequest, httpServletResponse, portlet, layoutTypePortlet.getLayout(), event);
                }
            }
        }
    }
}

