/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseMVCActionCommand
implements MVCActionCommand {
    @Override
    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        try {
            this.doProcessAction(actionRequest, actionResponse);
            return SessionErrors.isEmpty((PortletRequest)actionRequest);
        }
        catch (PortletException portletException) {
            throw portletException;
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
    }

    protected void addDeleteSuccessData(PortletRequest portletRequest, Object data) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".deleteSuccessData", data);
        this.hideDefaultSuccessMessage(portletRequest);
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        PortletConfig portletConfig = (PortletConfig)actionRequest.getAttribute("javax.portlet.config");
        boolean addProcessActionSuccessMessage = GetterUtil.getBoolean(portletConfig.getInitParameter("add-process-action-success-action"), true);
        if (!addProcessActionSuccessMessage) {
            return;
        }
        String successMessage = ParamUtil.getString((PortletRequest)actionRequest, "successMessage");
        SessionMessages.add((PortletRequest)actionRequest, "requestProcessed", (Object)successMessage);
    }

    protected abstract void doProcessAction(ActionRequest var1, ActionResponse var2) throws Exception;

    protected PortletConfig getPortletConfig(PortletRequest portletRequest) {
        return PortletConfigFactoryUtil.get(PortletIdCodec.decodePortletName(PortalUtil.getPortletId(portletRequest)));
    }

    protected void hideDefaultErrorMessage(PortletRequest portletRequest) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".hideDefaultErrorMessage");
    }

    protected void hideDefaultSuccessMessage(PortletRequest portletRequest) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".hideDefaultSuccessMessage");
    }

    protected boolean isDisplaySuccessMessage(PortletRequest portletRequest) {
        if (!SessionErrors.isEmpty(portletRequest)) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            return true;
        }
        String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (layoutTypePortlet.hasPortletId(portletId)) {
            return true;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(), portletId);
        return portlet.isAddDefaultResource();
    }

    protected boolean redirectToLogin(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        if (actionRequest.getRemoteUser() == null) {
            HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            SessionErrors.add(httpServletRequest, PrincipalException.class.getName());
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this.sendRedirect(actionRequest, actionResponse, themeDisplay.getURLSignIn());
            return true;
        }
        return false;
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.sendRedirect(actionRequest, actionResponse, null);
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse, String redirect) throws IOException {
        this.sendRedirect(null, actionRequest, actionResponse, redirect, null);
    }

    protected void sendRedirect(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String redirect, String closeRedirect) throws IOException {
        if (this.isDisplaySuccessMessage((PortletRequest)actionRequest)) {
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        if (Validator.isNull(redirect)) {
            redirect = (String)actionRequest.getAttribute("REDIRECT");
        }
        if (Validator.isNull(redirect)) {
            redirect = ParamUtil.getString((PortletRequest)actionRequest, "redirect");
        }
        if (portletConfig != null && Validator.isNotNull(redirect) && Validator.isNotNull(closeRedirect)) {
            redirect = HttpComponentsUtil.setParameter(redirect, "closeRedirect", closeRedirect);
            SessionMessages.add((PortletRequest)actionRequest, PortalUtil.getPortletId((PortletRequest)actionRequest) + ".closeRedirect", (Object)closeRedirect);
        }
        if (Validator.isNull(redirect)) {
            return;
        }
        if (Validator.isNotNull(redirect = PortalUtil.escapeRedirect(redirect))) {
            actionResponse.sendRedirect(redirect);
        }
    }
}

