/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Date;
import java.util.Map;

public class JobStateSerializeUtil {
    private static final String _TRIGGER_DATES_FIELD = "triggerDates";
    private static final String _TRIGGER_STATE_FIELD = "triggerState";
    private static final String _VERSION_FIELD = "version";

    public static JobState deserialize(Map<String, Object> jobStateMap) {
        Object object = jobStateMap.get(_VERSION_FIELD);
        if (!(object instanceof Integer)) {
            throw new IllegalStateException("Unable to find JobState version number");
        }
        int version = (Integer)object;
        if (version == 1) {
            return JobStateSerializeUtil._deserialize_1(jobStateMap);
        }
        throw new IllegalStateException("Unable to deserialize field for job state with version " + version);
    }

    public static Map<String, Object> serialize(JobState jobState) {
        return JobStateSerializeUtil._serialize_1(jobState);
    }

    private static JobState _deserialize_1(Map<String, Object> jobStateMap) {
        TriggerState triggerState = null;
        String triggerStateString = (String)jobStateMap.get(_TRIGGER_STATE_FIELD);
        try {
            triggerState = TriggerState.valueOf(triggerStateString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("Invalid value " + triggerStateString, illegalArgumentException);
        }
        Map triggerDates = (Map)jobStateMap.get(_TRIGGER_DATES_FIELD);
        JobState jobState = null;
        jobState = triggerDates != null ? new JobState(triggerState, triggerDates) : new JobState(triggerState);
        return jobState;
    }

    private static Map<String, Object> _serialize_1(JobState jobState) {
        return HashMapBuilder.put(_TRIGGER_DATES_FIELD, jobState.getTriggerDates()).put(_TRIGGER_STATE_FIELD, (Map<String, Date>)((Object)String.valueOf((Object)jobState.getTriggerState()))).put(_VERSION_FIELD, (Map<String, Date>)1).build();
    }
}

