/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameField;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FullNameDefinitionFactory {
    private static final FullNameDefinitionFactory _fullNameDefinitionFactory = new FullNameDefinitionFactory();
    private final Map<Locale, FullNameDefinition> _fullNameDefinitions = new ConcurrentHashMap<Locale, FullNameDefinition>();

    public static FullNameDefinition getInstance(Locale locale) {
        return _fullNameDefinitionFactory._getInstance(locale);
    }

    private FullNameDefinitionFactory() {
    }

    private FullNameField _getFullNameField(Locale locale, String userNameField, boolean required) {
        FullNameField fullNameField = new FullNameField();
        fullNameField.setName(userNameField);
        fullNameField.setRequired(required);
        String[] values = null;
        if (userNameField.equals("prefix")) {
            values = StringUtil.split(LanguageUtil.get(locale, "lang.user.name.prefix.values", ""));
        } else if (userNameField.equals("suffix")) {
            values = StringUtil.split(LanguageUtil.get(locale, "lang.user.name.suffix.values", ""));
        }
        fullNameField.setValues(values);
        return fullNameField;
    }

    private FullNameDefinition _getInstance(Locale locale) {
        String[] requiredFieldNames;
        FullNameDefinition fullNameDefinition = this._fullNameDefinitions.get(locale);
        if (fullNameDefinition != null) {
            return fullNameDefinition;
        }
        fullNameDefinition = new FullNameDefinition();
        for (String requiredFieldName : requiredFieldNames = this._getRequiredFieldNames(locale)) {
            fullNameDefinition.addRequiredField(requiredFieldName);
        }
        String[] fieldNames = StringUtil.split(LanguageUtil.get(locale, "lang.user.name.field.names"));
        for (String userNameField : fieldNames = this._includeRequiredFieldNames(requiredFieldNames, fieldNames)) {
            FullNameField fullNameField = this._getFullNameField(locale, userNameField, fullNameDefinition.isFieldRequired(userNameField));
            fullNameDefinition.addFullNameField(fullNameField);
        }
        this._fullNameDefinitions.put(locale, fullNameDefinition);
        return fullNameDefinition;
    }

    private String[] _getRequiredFieldNames(Locale locale) {
        Object[] requiredFieldNames = StringUtil.split(LanguageUtil.get(locale, "lang.user.name.required.field.names"));
        if (!ArrayUtil.contains(requiredFieldNames, "first-name")) {
            requiredFieldNames = (String[])ArrayUtil.append(new String[]{"first-name"}, requiredFieldNames);
        }
        return requiredFieldNames;
    }

    private String[] _includeRequiredFieldNames(String[] requiredFieldNames, String[] fieldNames) {
        fieldNames = ArrayUtil.append(requiredFieldNames, fieldNames);
        ArrayUtil.reverse(fieldNames);
        fieldNames = ArrayUtil.unique(fieldNames);
        ArrayUtil.reverse(fieldNames);
        return fieldNames;
    }
}

