/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.service.RetryAcceptor;
import java.util.Map;

public class ExceptionRetryAcceptor
implements RetryAcceptor {
    public static final String EXCEPTION_NAME = "EXCEPTION_NAME";

    @Override
    public boolean acceptException(Throwable throwable, Map<String, String> propertyMap) {
        String name = propertyMap.get(EXCEPTION_NAME);
        if (name == null) {
            throw new IllegalArgumentException("Missing property EXCEPTION_NAME");
        }
        while (true) {
            Class<?> clazz;
            ClassLoader classLoader;
            if ((classLoader = (clazz = throwable.getClass()).getClassLoader()) == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> exceptionClass = classLoader.loadClass(name);
                if (exceptionClass.isInstance(throwable)) {
                    return true;
                }
            }
            catch (ClassNotFoundException exceptionClass) {
                // empty catch block
            }
            Throwable causeThrowable = throwable.getCause();
            if (throwable == causeThrowable || causeThrowable == null) break;
            throwable = causeThrowable;
        }
        return false;
    }

    @Override
    public boolean acceptResult(Object returnValue, Map<String, String> propertyMap) {
        return false;
    }
}

