/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;

public class UserGroupRolePermissionUtil {
    public static void check(PermissionChecker permissionChecker, Group group, Role role) throws PortalException {
        if (!UserGroupRolePermissionUtil.contains(permissionChecker, group, role)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long roleId) throws PortalException {
        if (!UserGroupRolePermissionUtil.contains(permissionChecker, groupId, roleId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, Group group, Role role) throws PortalException {
        String roleName;
        if (role.getType() == 1) {
            return false;
        }
        if (role.getType() == 3 && !group.isOrganization()) {
            return false;
        }
        if (!permissionChecker.isCompanyAdmin() && !permissionChecker.isGroupOwner(group.getGroupId()) && ((roleName = role.getName()).equals("Organization Administrator") || roleName.equals("Organization Owner") || roleName.equals("Site Administrator") || roleName.equals("Site Owner"))) {
            return false;
        }
        return permissionChecker.isGroupOwner(group.getGroupId()) || GroupPermissionUtil.contains(permissionChecker, group, "ASSIGN_USER_ROLES") || OrganizationPermissionUtil.contains(permissionChecker, group.getOrganizationId(), "ASSIGN_USER_ROLES") || RolePermissionUtil.contains(permissionChecker, group.getGroupId(), role.getRoleId(), "ASSIGN_MEMBERS");
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long roleId) throws PortalException {
        return UserGroupRolePermissionUtil.contains(permissionChecker, GroupLocalServiceUtil.getGroup(groupId), RoleLocalServiceUtil.getRole(roleId));
    }
}

