/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.persistence.impl;

import com.liferay.portal.kernel.model.NestedSetsTreeNodeModel;
import java.util.List;
import java.util.Objects;

public abstract class NestedSetsTreeManager<T extends NestedSetsTreeNodeModel> {
    public long countAncestors(T t) {
        return this.doCountAncestors(t.getNestedSetsTreeNodeScopeId(), t.getNestedSetsTreeNodeLeft(), t.getNestedSetsTreeNodeRight());
    }

    public long countDescendants(T t) {
        return this.doCountDescendants(t.getNestedSetsTreeNodeScopeId(), t.getNestedSetsTreeNodeLeft(), t.getNestedSetsTreeNodeRight());
    }

    public void delete(T t) {
        this.doUpdate(t.getNestedSetsTreeNodeScopeId(), -1L, t.getNestedSetsTreeNodeLeft(), false, t.getNestedSetsTreeNodeRight(), false, null);
        this.doUpdate(t.getNestedSetsTreeNodeScopeId(), true, -2L, t.getNestedSetsTreeNodeRight(), false);
        this.doUpdate(t.getNestedSetsTreeNodeScopeId(), false, -2L, t.getNestedSetsTreeNodeRight(), false);
    }

    public List<T> getAncestors(T t) {
        return this.doGetAncestors(t.getNestedSetsTreeNodeScopeId(), t.getNestedSetsTreeNodeLeft(), t.getNestedSetsTreeNodeRight());
    }

    public List<T> getDescendants(T t) {
        return this.doGetDescendants(t.getNestedSetsTreeNodeScopeId(), t.getNestedSetsTreeNodeLeft(), t.getNestedSetsTreeNodeRight());
    }

    public void insert(T t, T parentT) {
        if (parentT == null) {
            long maxNestedSetsTreeNodeRight = this.getMaxNestedSetsTreeNodeRight(t.getNestedSetsTreeNodeScopeId());
            t.setNestedSetsTreeNodeLeft(maxNestedSetsTreeNodeRight);
            t.setNestedSetsTreeNodeRight(maxNestedSetsTreeNodeRight + 1L);
        } else {
            this.doUpdate(t.getNestedSetsTreeNodeScopeId(), true, 2L, parentT.getNestedSetsTreeNodeRight(), true);
            this.doUpdate(t.getNestedSetsTreeNodeScopeId(), false, 2L, parentT.getNestedSetsTreeNodeRight(), true);
            t.setNestedSetsTreeNodeLeft(parentT.getNestedSetsTreeNodeRight());
            t.setNestedSetsTreeNodeRight(parentT.getNestedSetsTreeNodeRight() + 1L);
        }
    }

    public void move(T t, T oldParentT, T newParentT) {
        if (Objects.equals(oldParentT, newParentT)) {
            return;
        }
        List<T> descendants = this.doGetDescendants(t.getNestedSetsTreeNodeScopeId(), t.getNestedSetsTreeNodeLeft(), t.getNestedSetsTreeNodeRight());
        long newParentNestedSetsTreeNodeRight = 0L;
        newParentNestedSetsTreeNodeRight = newParentT == null ? this.getMaxNestedSetsTreeNodeRight(t.getNestedSetsTreeNodeScopeId()) : newParentT.getNestedSetsTreeNodeRight();
        long delta = 0L;
        if (t.getNestedSetsTreeNodeRight() < newParentNestedSetsTreeNodeRight) {
            this.doUpdate(t.getNestedSetsTreeNodeScopeId(), -(t.getNestedSetsTreeNodeRight() - t.getNestedSetsTreeNodeLeft() + 1L), t.getNestedSetsTreeNodeRight(), false, newParentNestedSetsTreeNodeRight, false, null);
            delta = newParentNestedSetsTreeNodeRight - t.getNestedSetsTreeNodeRight() - 1L;
            this.doUpdate(t.getNestedSetsTreeNodeScopeId(), delta, t.getNestedSetsTreeNodeLeft(), true, t.getNestedSetsTreeNodeRight(), true, descendants);
        } else {
            this.doUpdate(t.getNestedSetsTreeNodeScopeId(), t.getNestedSetsTreeNodeRight() - t.getNestedSetsTreeNodeLeft() + 1L, newParentNestedSetsTreeNodeRight, true, t.getNestedSetsTreeNodeLeft(), false, null);
            delta = newParentNestedSetsTreeNodeRight - t.getNestedSetsTreeNodeLeft();
            this.doUpdate(t.getNestedSetsTreeNodeScopeId(), delta, t.getNestedSetsTreeNodeLeft(), true, t.getNestedSetsTreeNodeRight(), true, descendants);
        }
        t.setNestedSetsTreeNodeLeft(t.getNestedSetsTreeNodeLeft() + delta);
        t.setNestedSetsTreeNodeRight(t.getNestedSetsTreeNodeRight() + delta);
    }

    protected abstract long doCountAncestors(long var1, long var3, long var5);

    protected abstract long doCountDescendants(long var1, long var3, long var5);

    protected abstract List<T> doGetAncestors(long var1, long var3, long var5);

    protected abstract List<T> doGetDescendants(long var1, long var3, long var5);

    protected abstract void doUpdate(long var1, boolean var3, long var4, long var6, boolean var8);

    protected abstract void doUpdate(long var1, long var3, long var5, boolean var7, long var8, boolean var10, List<T> var11);

    protected abstract long getMaxNestedSetsTreeNodeRight(long var1);
}

