/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.SystemProperties;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpOnlyCookieServletResponse
extends HttpServletResponseWrapper {
    private static final Set<String> _httpOnlyCookieNames = new HashSet<String>(){
        {
            this.add("CONSENT_TYPE_FUNCTIONAL");
            this.add("CONSENT_TYPE_NECESSARY");
            this.add("CONSENT_TYPE_PERFORMANCE");
            this.add("CONSENT_TYPE_PERSONALIZATION");
            this.add("USER_CONSENT_CONFIGURED");
            for (String cookieName : SystemProperties.getArray("cookie.http.only.names.excludes")) {
                this.add(cookieName);
            }
        }
    };

    public static HttpServletResponse getHttpOnlyCookieServletResponse(HttpServletResponse httpServletResponse) {
        HttpServletResponse wrappedHttpServletResponse = httpServletResponse;
        while (wrappedHttpServletResponse instanceof HttpServletResponseWrapper) {
            if (wrappedHttpServletResponse instanceof HttpOnlyCookieServletResponse) {
                return httpServletResponse;
            }
            HttpServletResponseWrapper httpServletResponseWrapper = (HttpServletResponseWrapper)wrappedHttpServletResponse;
            wrappedHttpServletResponse = (HttpServletResponse)httpServletResponseWrapper.getResponse();
        }
        return new HttpOnlyCookieServletResponse(httpServletResponse);
    }

    public HttpOnlyCookieServletResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void addCookie(Cookie cookie) {
        if (!_httpOnlyCookieNames.contains(cookie.getName())) {
            cookie.setHttpOnly(true);
        }
        super.addCookie(cookie);
    }
}

