/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalDelegatorServlet
extends HttpServlet {
    private static final Map<String, HttpServlet> _delegates = new HashMap<String, HttpServlet>();

    public static void addDelegate(String subcontext, HttpServlet delegate) {
        if (subcontext == null || delegate == null) {
            throw new IllegalArgumentException();
        }
        _delegates.put(subcontext, delegate);
    }

    public static void removeDelegate(String subcontext) {
        if (subcontext == null) {
            throw new IllegalArgumentException();
        }
        _delegates.remove(subcontext);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String uri = httpServletRequest.getPathInfo();
        if (uri == null || uri.length() == 0) {
            httpServletResponse.sendError(404, "Path information is not specified");
            return;
        }
        String[] paths = uri.split("/");
        if (paths.length < 2) {
            httpServletResponse.sendError(404, "Path " + uri + " is invalid");
            return;
        }
        HttpServlet delegate = _delegates.get(paths[1]);
        if (delegate == null) {
            httpServletResponse.sendError(404, "No servlet registred for context " + paths[1]);
            return;
        }
        Class<?> clazz = delegate.getClass();
        ClassLoader delegateClassLoader = clazz.getClassLoader();
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)delegateClassLoader);){
            delegate.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }
}

