/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DynamicIncludeUtil {
    private static final Log _log = LogFactoryUtil.getLog(DynamicIncludeUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, List<DynamicInclude>> _dynamicIncludes = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)_bundleContext, DynamicInclude.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, DynamicInclude>(){

        public void map(ServiceReference<DynamicInclude> serviceReference, final ServiceReferenceMapper.Emitter<String> emitter) {
            DynamicInclude dynamicInclude = (DynamicInclude)_bundleContext.getService(serviceReference);
            dynamicInclude.register(new DynamicInclude.DynamicIncludeRegistry(){

                @Override
                public void register(String key) {
                    emitter.emit((Object)key);
                }
            });
            _bundleContext.ungetService(serviceReference);
        }
    });

    public static List<DynamicInclude> getDynamicIncludes(String key) {
        return (List)_dynamicIncludes.getService((Object)key);
    }

    public static boolean hasDynamicInclude(String key) {
        return !ListUtil.isEmpty(DynamicIncludeUtil.getDynamicIncludes(key));
    }

    public static void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key, boolean ascendingPriority) {
        List<DynamicInclude> dynamicIncludes = DynamicIncludeUtil.getDynamicIncludes(key);
        if (ListUtil.isEmpty(dynamicIncludes)) {
            return;
        }
        Iterator<DynamicInclude> iterator = null;
        iterator = ascendingPriority ? dynamicIncludes.iterator() : ListUtil.reverseIterator(dynamicIncludes);
        while (iterator.hasNext()) {
            DynamicInclude dynamicInclude = iterator.next();
            try {
                dynamicInclude.include(httpServletRequest, httpServletResponse, key);
            }
            catch (Exception exception) {
                _log.error(exception);
            }
        }
    }

    private DynamicIncludeUtil() {
    }
}

