/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class BaseCompanyIdUpgradeProcess
extends UpgradeProcess {
    private boolean _processConcurrently = true;

    protected void disableProcessConcurrently() {
        this._processConcurrently = false;
    }

    @Override
    protected void doUpgrade() throws Exception {
        if (DBManagerUtil.getDBType() == DBType.SQLSERVER || !this._processConcurrently) {
            for (TableUpdater tableUpdater2 : this.getTableUpdaters()) {
                this._addCompanyIdColumn(tableUpdater2);
            }
        } else {
            this.processConcurrently(this.getTableUpdaters(), tableUpdater -> this._addCompanyIdColumn((TableUpdater)tableUpdater), null);
        }
    }

    protected abstract TableUpdater[] getTableUpdaters();

    private void _addCompanyIdColumn(TableUpdater tableUpdater) throws Exception {
        String tableName = tableUpdater.getTableName();
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            this.alterTableAddColumn(tableName, "companyId", "LONG");
            tableUpdater.update(this.connection);
        }
    }

    protected class TableUpdater {
        private final String _columnName;
        private final String[][] _foreignNamesArray;
        private final String _tableName;

        public TableUpdater(String tableName, String foreignTableName, String columnName) {
            this._tableName = tableName;
            this._columnName = columnName;
            this._foreignNamesArray = new String[][]{{foreignTableName, columnName}};
        }

        public TableUpdater(String tableName, String columnName, String[][] foreignNamesArray) {
            this._tableName = tableName;
            this._columnName = columnName;
            this._foreignNamesArray = foreignNamesArray;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void update(Connection connection) throws Exception {
            for (String[] foreignNames : this._foreignNamesArray) {
                BaseCompanyIdUpgradeProcess.this.runSQL(this.getUpdateDBTypeToSQLMap(connection, foreignNames[0], foreignNames[1]));
            }
        }

        protected DBTypeToSQLMap getUpdateDBTypeToSQLMap(Connection connection, String foreignTableName, String foreignColumnName) throws SQLException {
            DBTypeToSQLMap dbTypeToSQLMap = null;
            ArrayList<Long> companyIds = new ArrayList<Long>();
            try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    companyIds.add(resultSet.getLong(1));
                }
            }
            if (companyIds.size() == 1) {
                dbTypeToSQLMap = new DBTypeToSQLMap(this.getUpdateSQL(String.valueOf(companyIds.get(0))));
            } else {
                dbTypeToSQLMap = new DBTypeToSQLMap(this.getUpdateSQL(StringBundler.concat((String[])new String[]{"select max(companyId) from ", foreignTableName, " where ", foreignTableName, ".", foreignColumnName, " > 0 and ", foreignTableName, ".", foreignColumnName, " = ", this._tableName, ".", this._columnName})));
                dbTypeToSQLMap.add(DBType.POSTGRESQL, this.getUpdateSQL(StringBundler.concat((String[])new String[]{"select ", foreignTableName, ".companyId from ", foreignTableName, " where ", foreignTableName, ".", foreignColumnName, " > 0 and ", foreignTableName, ".", foreignColumnName, " = ", this._tableName, ".", this._columnName, " order by ", foreignTableName, ".companyId desc limit 1"})));
            }
            return dbTypeToSQLMap;
        }

        protected String getUpdateSQL(String selectSQL) {
            return StringBundler.concat((String[])new String[]{"update ", this._tableName, " set companyId = (", selectSQL, ")"});
        }
    }

    protected class PortletPreferencesTableUpdater
    extends TableUpdater {
        public PortletPreferencesTableUpdater(String tableName) {
            super(tableName, "", "");
        }

        @Override
        public void update(Connection connection) throws IOException, SQLException {
            long[] companyIds = PortalInstancePool.getCompanyIds();
            if (companyIds.length == 1) {
                BaseCompanyIdUpgradeProcess.this.runSQL(connection, this.getUpdateSQL(String.valueOf(companyIds[0])));
                return;
            }
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("Company", "companyId", "ownerId", 1));
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("Group_", "groupId", "ownerId", 2));
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("Layout", "plid", "plid", 3));
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("LayoutRevision", "layoutRevisionId", "plid", 3));
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("Organization_", "organizationId", "ownerId", 6));
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("PortletItem", "portletItemId", "ownerId", 5));
            BaseCompanyIdUpgradeProcess.this.runSQL(connection, this._getUpdateSQL("User_", "userId", "ownerId", 4));
        }

        private String _getSelectSQL(String foreignTableName, String foreignColumnName, String columnName) throws SQLException {
            ArrayList<Long> companyIds = new ArrayList<Long>();
            try (PreparedStatement preparedStatement = BaseCompanyIdUpgradeProcess.this.connection.prepareStatement("select distinct companyId from " + foreignTableName);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong(1);
                    companyIds.add(companyId);
                }
            }
            if (companyIds.size() == 1) {
                return String.valueOf(companyIds.get(0));
            }
            return StringBundler.concat((String[])new String[]{"select companyId from ", foreignTableName, " where ", foreignTableName, ".", foreignColumnName, " = ", this.getTableName(), ".", columnName});
        }

        private String _getUpdateSQL(String foreignTableName, String foreignColumnName, String columnName, int ownerType) throws IOException, SQLException {
            return StringBundler.concat((Object[])new Object[]{this.getUpdateSQL(this._getSelectSQL(foreignTableName, foreignColumnName, columnName)), " where ownerType = ", ownerType, " and (companyId is null or companyId = 0)"});
        }
    }
}

