/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

public class CTModelUpgradeProcess
extends UpgradeProcess {
    private final String[] _tableNames;

    public CTModelUpgradeProcess(String ... tableNames) {
        if (tableNames.length == 0) {
            throw new IllegalArgumentException("Table names is empty");
        }
        this._tableNames = tableNames;
    }

    @Override
    protected void doUpgrade() throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        DBInspector dbInspector = new DBInspector(this.connection);
        for (String tableName : this._tableNames) {
            try (LoggingTimer loggingTimer = new LoggingTimer(CTModelUpgradeProcess.class, tableName);){
                this._upgradeCTModel(databaseMetaData, dbInspector, tableName);
            }
        }
    }

    private void _upgradeCTModel(DatabaseMetaData databaseMetaData, DBInspector dbInspector, String tableName) throws Exception {
        String normalizedTableName = dbInspector.normalizeName(tableName, databaseMetaData);
        this.ensureTableExists(databaseMetaData, dbInspector, normalizedTableName);
        try (ResultSet resultSet = databaseMetaData.getColumns(dbInspector.getCatalog(), dbInspector.getSchema(), normalizedTableName, dbInspector.normalizeName("ctCollectionId", databaseMetaData));){
            if (resultSet.next()) {
                return;
            }
        }
        String[] primaryKeyColumnNames = this.getPrimaryKeyColumnNames(this.connection, tableName);
        if (primaryKeyColumnNames.length == 0) {
            throw new UpgradeException("No primary key column found for " + normalizedTableName);
        }
        if (primaryKeyColumnNames.length > 2) {
            throw new UpgradeException("Too many primary key columns to upgrade " + normalizedTableName);
        }
        String primaryKeyColumnName1 = primaryKeyColumnNames[0];
        String primaryKeyColumnName2 = null;
        if (primaryKeyColumnNames.length == 2) {
            primaryKeyColumnName2 = primaryKeyColumnNames[1];
        }
        this.alterTableAddColumn(normalizedTableName, "ctCollectionId", "LONG default 0 not null");
        if (primaryKeyColumnName2 != null) {
            this.alterTableAddColumn(normalizedTableName, "ctChangeType", "BOOLEAN default null");
        }
        this.removePrimaryKey(tableName);
        StringBundler sb = new StringBundler(7);
        sb.append("alter table ");
        sb.append(normalizedTableName);
        sb.append(" add primary key (");
        sb.append(primaryKeyColumnName1);
        if (primaryKeyColumnName2 != null) {
            sb.append(", ");
            sb.append(primaryKeyColumnName2);
        }
        sb.append(", ctCollectionId)");
        this.runSQL(sb.toString());
    }
}

