/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.url;

import com.liferay.portal.kernel.util.HttpComponentsUtil;
import java.util.LinkedList;
import java.util.List;

public class URLBuilder {
    private String _url;
    private final List<URLOperation> _urlOperations = new LinkedList<URLOperation>();

    public static URLBuilder create(String url) {
        return new URLBuilder(url);
    }

    public URLBuilder addParameter(String name, String value) {
        this._urlOperations.add(new URLOperation(name, OperationType.ADD, value));
        return this;
    }

    public String build() {
        if (this._url == null) {
            return null;
        }
        for (URLOperation urlOperation : this._urlOperations) {
            String name = urlOperation.getName();
            OperationType operationType = urlOperation.getOperationType();
            String value = urlOperation.getValue();
            if (operationType == OperationType.ADD) {
                this._url = HttpComponentsUtil.addParameter(this._url, name, value);
                continue;
            }
            if (operationType == OperationType.SET) {
                this._url = HttpComponentsUtil.setParameter(this._url, name, value);
                continue;
            }
            if (operationType != OperationType.REMOVE) continue;
            this._url = HttpComponentsUtil.removeParameter(this._url, name);
        }
        this._urlOperations.clear();
        return this._url;
    }

    public URLBuilder removeParameter(String name) {
        this._urlOperations.add(new URLOperation(name, OperationType.REMOVE, null));
        return this;
    }

    public URLBuilder setParameter(String name, String value) {
        this._urlOperations.add(new URLOperation(name, OperationType.SET, value));
        return this;
    }

    private URLBuilder(String url) {
        this._url = url;
    }

    private static enum OperationType {
        ADD,
        REMOVE,
        SET;

    }

    private static class URLOperation {
        private final String _name;
        private final OperationType _operationType;
        private final String _value;

        public String getName() {
            return this._name;
        }

        public OperationType getOperationType() {
            return this._operationType;
        }

        public String getValue() {
            return this._value;
        }

        private URLOperation(String name, OperationType operationType, String value) {
            this._name = name;
            this._operationType = operationType;
            this._value = value;
        }
    }
}

