/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InstancePool {
    private static final Log _log = LogFactoryUtil.getLog(InstancePool.class);
    private static final Map<String, Object> _instances = new ConcurrentHashMap<String, Object>();

    public static boolean contains(String className) {
        return _instances.containsKey(className.trim());
    }

    public static Object get(String className) {
        return InstancePool.get(className, true);
    }

    public static Object get(String className, boolean logErrors) {
        Object instance;
        block6: {
            instance = _instances.get(className = className.trim());
            if (instance != null) {
                return instance;
            }
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            try {
                Class<?> clazz = portalClassLoader.loadClass(className);
                instance = clazz.newInstance();
                _instances.put(className, instance);
            }
            catch (Exception exception1) {
                if (logErrors && _log.isWarnEnabled()) {
                    _log.warn("Unable to load " + className + " with the portal class loader", exception1);
                }
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    Class<?> clazz = contextClassLoader.loadClass(className);
                    instance = clazz.newInstance();
                    _instances.put(className, instance);
                }
                catch (Exception exception2) {
                    if (!logErrors) break block6;
                    _log.error(StringBundler.concat((String[])new String[]{"Unable to load ", className, " with the portal class loader or the current ", "context class loader"}), exception2);
                }
            }
        }
        return instance;
    }

    public static void put(String className, Object object) {
        _instances.put(className.trim(), object);
    }

    public static void reset() {
        _instances.clear();
    }

    private InstancePool() {
    }
}

