/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.servlet.ServletContext;

public class PortletTitleComparator
implements Comparator<Portlet>,
Serializable {
    private final boolean _ascending;
    private final Collator _collator;
    private final Locale _locale;
    private final ServletContext _servletContext;

    public PortletTitleComparator(Locale locale) {
        this(null, locale);
    }

    public PortletTitleComparator(ServletContext servletContext, Locale locale) {
        this(servletContext, locale, true);
    }

    public PortletTitleComparator(ServletContext servletContext, Locale locale, boolean ascending) {
        this._servletContext = servletContext;
        this._locale = locale;
        this._ascending = ascending;
        this._collator = CollatorUtil.getInstance(locale);
    }

    @Override
    public int compare(Portlet portlet1, Portlet portlet2) {
        String portletTitle1 = "";
        String portletTitle2 = "";
        if (this._servletContext != null) {
            portletTitle1 = PortalUtil.getPortletTitle(portlet1, this._servletContext, this._locale);
            portletTitle2 = PortalUtil.getPortletTitle(portlet2, this._servletContext, this._locale);
        } else {
            portletTitle1 = PortalUtil.getPortletTitle(portlet1, this._locale);
            portletTitle2 = PortalUtil.getPortletTitle(portlet2, this._locale);
        }
        if (Validator.isNull(portletTitle1) && Validator.isNull(portletTitle2)) {
            return 0;
        }
        if (Validator.isNull(portletTitle1)) {
            return 1;
        }
        if (Validator.isNull(portletTitle2)) {
            return -1;
        }
        int value = this._collator.compare(portletTitle1, portletTitle2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }
}

