/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.workflow.WorkflowNode;
import java.util.Locale;
import java.util.Map;

public abstract class BaseWorkflowNode
implements WorkflowNode {
    private Map<Locale, String> _labelMap;
    private String _name;
    private WorkflowNode.Type _type;

    @Override
    public String getLabel(Locale locale) {
        if (MapUtil.isNotEmpty(this._labelMap) && this._labelMap.get(locale) != null) {
            return HtmlUtil.escape(this._labelMap.get(locale));
        }
        String name = LanguageUtil.get(locale, this._name, null);
        if (name != null) {
            return HtmlUtil.escape(name);
        }
        String label = this._labelMap.get(LocaleUtil.getSiteDefault());
        if (label != null) {
            return HtmlUtil.escape(label);
        }
        return this._name;
    }

    @Override
    public Map<Locale, String> getLabelMap() {
        return this._labelMap;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public WorkflowNode.Type getType() {
        return this._type;
    }

    public void setLabelMap(Map<Locale, String> labelMap) {
        this._labelMap = labelMap;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(WorkflowNode.Type type) {
        this._type = type;
    }
}

