/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserModel;
import com.liferay.portal.model.UserSoap;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the User service. Represents a row in the &quot;User_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link com.liferay.portal.model.UserModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserImpl
 * @see com.liferay.portal.model.User
 * @see com.liferay.portal.model.UserModel
 * @generated
 */
@JSON(strict = true)
public class UserModelImpl extends BaseModelImpl<User> implements UserModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user model instance should use the {@link com.liferay.portal.model.User} interface instead.
	 */
	public static final String TABLE_NAME = "User_";
	public static final Object[][] TABLE_COLUMNS = {
			{ "uuid_", Types.VARCHAR },
			{ "userId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "defaultUser", Types.BOOLEAN },
			{ "contactId", Types.BIGINT },
			{ "password_", Types.VARCHAR },
			{ "passwordEncrypted", Types.BOOLEAN },
			{ "passwordReset", Types.BOOLEAN },
			{ "passwordModifiedDate", Types.TIMESTAMP },
			{ "digest", Types.VARCHAR },
			{ "reminderQueryQuestion", Types.VARCHAR },
			{ "reminderQueryAnswer", Types.VARCHAR },
			{ "graceLoginCount", Types.INTEGER },
			{ "screenName", Types.VARCHAR },
			{ "emailAddress", Types.VARCHAR },
			{ "facebookId", Types.BIGINT },
			{ "ldapServerId", Types.BIGINT },
			{ "openId", Types.VARCHAR },
			{ "portraitId", Types.BIGINT },
			{ "languageId", Types.VARCHAR },
			{ "timeZoneId", Types.VARCHAR },
			{ "greeting", Types.VARCHAR },
			{ "comments", Types.VARCHAR },
			{ "firstName", Types.VARCHAR },
			{ "middleName", Types.VARCHAR },
			{ "lastName", Types.VARCHAR },
			{ "jobTitle", Types.VARCHAR },
			{ "loginDate", Types.TIMESTAMP },
			{ "loginIP", Types.VARCHAR },
			{ "lastLoginDate", Types.TIMESTAMP },
			{ "lastLoginIP", Types.VARCHAR },
			{ "lastFailedLoginDate", Types.TIMESTAMP },
			{ "failedLoginAttempts", Types.INTEGER },
			{ "lockout", Types.BOOLEAN },
			{ "lockoutDate", Types.TIMESTAMP },
			{ "agreedToTermsOfUse", Types.BOOLEAN },
			{ "emailAddressVerified", Types.BOOLEAN },
			{ "status", Types.INTEGER }
		};
	public static final String TABLE_SQL_CREATE = "create table User_ (uuid_ VARCHAR(75) null,userId LONG not null primary key,companyId LONG,createDate DATE null,modifiedDate DATE null,defaultUser BOOLEAN,contactId LONG,password_ VARCHAR(75) null,passwordEncrypted BOOLEAN,passwordReset BOOLEAN,passwordModifiedDate DATE null,digest VARCHAR(255) null,reminderQueryQuestion VARCHAR(75) null,reminderQueryAnswer VARCHAR(75) null,graceLoginCount INTEGER,screenName VARCHAR(75) null,emailAddress VARCHAR(75) null,facebookId LONG,ldapServerId LONG,openId VARCHAR(1024) null,portraitId LONG,languageId VARCHAR(75) null,timeZoneId VARCHAR(75) null,greeting VARCHAR(255) null,comments STRING null,firstName VARCHAR(75) null,middleName VARCHAR(75) null,lastName VARCHAR(75) null,jobTitle VARCHAR(100) null,loginDate DATE null,loginIP VARCHAR(75) null,lastLoginDate DATE null,lastLoginIP VARCHAR(75) null,lastFailedLoginDate DATE null,failedLoginAttempts INTEGER,lockout BOOLEAN,lockoutDate DATE null,agreedToTermsOfUse BOOLEAN,emailAddressVerified BOOLEAN,status INTEGER)";
	public static final String TABLE_SQL_DROP = "drop table User_";
	public static final String ORDER_BY_JPQL = " ORDER BY user.userId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY User_.userId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.entity.cache.enabled.com.liferay.portal.model.User"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.com.liferay.portal.model.User"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.column.bitmask.enabled.com.liferay.portal.model.User"),
			true);
	public static long COMPANYID_COLUMN_BITMASK = 1L;
	public static long CONTACTID_COLUMN_BITMASK = 2L;
	public static long CREATEDATE_COLUMN_BITMASK = 4L;
	public static long DEFAULTUSER_COLUMN_BITMASK = 8L;
	public static long EMAILADDRESS_COLUMN_BITMASK = 16L;
	public static long FACEBOOKID_COLUMN_BITMASK = 32L;
	public static long MODIFIEDDATE_COLUMN_BITMASK = 64L;
	public static long OPENID_COLUMN_BITMASK = 128L;
	public static long PORTRAITID_COLUMN_BITMASK = 256L;
	public static long SCREENNAME_COLUMN_BITMASK = 512L;
	public static long STATUS_COLUMN_BITMASK = 1024L;
	public static long USERID_COLUMN_BITMASK = 2048L;
	public static long UUID_COLUMN_BITMASK = 4096L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static User toModel(UserSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		User model = new UserImpl();

		model.setUuid(soapModel.getUuid());
		model.setUserId(soapModel.getUserId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setDefaultUser(soapModel.getDefaultUser());
		model.setContactId(soapModel.getContactId());
		model.setPassword(soapModel.getPassword());
		model.setPasswordEncrypted(soapModel.getPasswordEncrypted());
		model.setPasswordReset(soapModel.getPasswordReset());
		model.setPasswordModifiedDate(soapModel.getPasswordModifiedDate());
		model.setDigest(soapModel.getDigest());
		model.setReminderQueryQuestion(soapModel.getReminderQueryQuestion());
		model.setReminderQueryAnswer(soapModel.getReminderQueryAnswer());
		model.setGraceLoginCount(soapModel.getGraceLoginCount());
		model.setScreenName(soapModel.getScreenName());
		model.setEmailAddress(soapModel.getEmailAddress());
		model.setFacebookId(soapModel.getFacebookId());
		model.setLdapServerId(soapModel.getLdapServerId());
		model.setOpenId(soapModel.getOpenId());
		model.setPortraitId(soapModel.getPortraitId());
		model.setLanguageId(soapModel.getLanguageId());
		model.setTimeZoneId(soapModel.getTimeZoneId());
		model.setGreeting(soapModel.getGreeting());
		model.setComments(soapModel.getComments());
		model.setFirstName(soapModel.getFirstName());
		model.setMiddleName(soapModel.getMiddleName());
		model.setLastName(soapModel.getLastName());
		model.setJobTitle(soapModel.getJobTitle());
		model.setLoginDate(soapModel.getLoginDate());
		model.setLoginIP(soapModel.getLoginIP());
		model.setLastLoginDate(soapModel.getLastLoginDate());
		model.setLastLoginIP(soapModel.getLastLoginIP());
		model.setLastFailedLoginDate(soapModel.getLastFailedLoginDate());
		model.setFailedLoginAttempts(soapModel.getFailedLoginAttempts());
		model.setLockout(soapModel.getLockout());
		model.setLockoutDate(soapModel.getLockoutDate());
		model.setAgreedToTermsOfUse(soapModel.getAgreedToTermsOfUse());
		model.setEmailAddressVerified(soapModel.getEmailAddressVerified());
		model.setStatus(soapModel.getStatus());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<User> toModels(UserSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<User> models = new ArrayList<User>(soapModels.length);

		for (UserSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final String MAPPING_TABLE_USERS_GROUPS_NAME = "Users_Groups";
	public static final Object[][] MAPPING_TABLE_USERS_GROUPS_COLUMNS = {
			{ "userId", Types.BIGINT },
			{ "groupId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_USERS_GROUPS_SQL_CREATE = "create table Users_Groups (groupId LONG not null,userId LONG not null,primary key (groupId, userId))";
	public static final boolean FINDER_CACHE_ENABLED_USERS_GROUPS = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Groups"), true);
	public static final String MAPPING_TABLE_USERS_ORGS_NAME = "Users_Orgs";
	public static final Object[][] MAPPING_TABLE_USERS_ORGS_COLUMNS = {
			{ "userId", Types.BIGINT },
			{ "organizationId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_USERS_ORGS_SQL_CREATE = "create table Users_Orgs (organizationId LONG not null,userId LONG not null,primary key (organizationId, userId))";
	public static final boolean FINDER_CACHE_ENABLED_USERS_ORGS = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Orgs"), true);
	public static final String MAPPING_TABLE_USERS_ROLES_NAME = "Users_Roles";
	public static final Object[][] MAPPING_TABLE_USERS_ROLES_COLUMNS = {
			{ "userId", Types.BIGINT },
			{ "roleId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_USERS_ROLES_SQL_CREATE = "create table Users_Roles (roleId LONG not null,userId LONG not null,primary key (roleId, userId))";
	public static final boolean FINDER_CACHE_ENABLED_USERS_ROLES = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Roles"), true);
	public static final String MAPPING_TABLE_USERS_TEAMS_NAME = "Users_Teams";
	public static final Object[][] MAPPING_TABLE_USERS_TEAMS_COLUMNS = {
			{ "userId", Types.BIGINT },
			{ "teamId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_USERS_TEAMS_SQL_CREATE = "create table Users_Teams (teamId LONG not null,userId LONG not null,primary key (teamId, userId))";
	public static final boolean FINDER_CACHE_ENABLED_USERS_TEAMS = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Teams"), true);
	public static final String MAPPING_TABLE_USERS_USERGROUPS_NAME = "Users_UserGroups";
	public static final Object[][] MAPPING_TABLE_USERS_USERGROUPS_COLUMNS = {
			{ "userGroupId", Types.BIGINT },
			{ "userId", Types.BIGINT }
		};
	public static final String MAPPING_TABLE_USERS_USERGROUPS_SQL_CREATE = "create table Users_UserGroups (userId LONG not null,userGroupId LONG not null,primary key (userId, userGroupId))";
	public static final boolean FINDER_CACHE_ENABLED_USERS_USERGROUPS = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_UserGroups"), true);
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.portal.util.PropsUtil.get(
				"lock.expiration.time.com.liferay.portal.model.User"));

	public UserModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _userId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setUserId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _userId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return User.class;
	}

	@Override
	public String getModelClassName() {
		return User.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("userId", getUserId());
		attributes.put("companyId", getCompanyId());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("defaultUser", getDefaultUser());
		attributes.put("contactId", getContactId());
		attributes.put("password", getPassword());
		attributes.put("passwordEncrypted", getPasswordEncrypted());
		attributes.put("passwordReset", getPasswordReset());
		attributes.put("passwordModifiedDate", getPasswordModifiedDate());
		attributes.put("digest", getDigest());
		attributes.put("reminderQueryQuestion", getReminderQueryQuestion());
		attributes.put("reminderQueryAnswer", getReminderQueryAnswer());
		attributes.put("graceLoginCount", getGraceLoginCount());
		attributes.put("screenName", getScreenName());
		attributes.put("emailAddress", getEmailAddress());
		attributes.put("facebookId", getFacebookId());
		attributes.put("ldapServerId", getLdapServerId());
		attributes.put("openId", getOpenId());
		attributes.put("portraitId", getPortraitId());
		attributes.put("languageId", getLanguageId());
		attributes.put("timeZoneId", getTimeZoneId());
		attributes.put("greeting", getGreeting());
		attributes.put("comments", getComments());
		attributes.put("firstName", getFirstName());
		attributes.put("middleName", getMiddleName());
		attributes.put("lastName", getLastName());
		attributes.put("jobTitle", getJobTitle());
		attributes.put("loginDate", getLoginDate());
		attributes.put("loginIP", getLoginIP());
		attributes.put("lastLoginDate", getLastLoginDate());
		attributes.put("lastLoginIP", getLastLoginIP());
		attributes.put("lastFailedLoginDate", getLastFailedLoginDate());
		attributes.put("failedLoginAttempts", getFailedLoginAttempts());
		attributes.put("lockout", getLockout());
		attributes.put("lockoutDate", getLockoutDate());
		attributes.put("agreedToTermsOfUse", getAgreedToTermsOfUse());
		attributes.put("emailAddressVerified", getEmailAddressVerified());
		attributes.put("status", getStatus());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Boolean defaultUser = (Boolean)attributes.get("defaultUser");

		if (defaultUser != null) {
			setDefaultUser(defaultUser);
		}

		Long contactId = (Long)attributes.get("contactId");

		if (contactId != null) {
			setContactId(contactId);
		}

		String password = (String)attributes.get("password");

		if (password != null) {
			setPassword(password);
		}

		Boolean passwordEncrypted = (Boolean)attributes.get("passwordEncrypted");

		if (passwordEncrypted != null) {
			setPasswordEncrypted(passwordEncrypted);
		}

		Boolean passwordReset = (Boolean)attributes.get("passwordReset");

		if (passwordReset != null) {
			setPasswordReset(passwordReset);
		}

		Date passwordModifiedDate = (Date)attributes.get("passwordModifiedDate");

		if (passwordModifiedDate != null) {
			setPasswordModifiedDate(passwordModifiedDate);
		}

		String digest = (String)attributes.get("digest");

		if (digest != null) {
			setDigest(digest);
		}

		String reminderQueryQuestion = (String)attributes.get(
				"reminderQueryQuestion");

		if (reminderQueryQuestion != null) {
			setReminderQueryQuestion(reminderQueryQuestion);
		}

		String reminderQueryAnswer = (String)attributes.get(
				"reminderQueryAnswer");

		if (reminderQueryAnswer != null) {
			setReminderQueryAnswer(reminderQueryAnswer);
		}

		Integer graceLoginCount = (Integer)attributes.get("graceLoginCount");

		if (graceLoginCount != null) {
			setGraceLoginCount(graceLoginCount);
		}

		String screenName = (String)attributes.get("screenName");

		if (screenName != null) {
			setScreenName(screenName);
		}

		String emailAddress = (String)attributes.get("emailAddress");

		if (emailAddress != null) {
			setEmailAddress(emailAddress);
		}

		Long facebookId = (Long)attributes.get("facebookId");

		if (facebookId != null) {
			setFacebookId(facebookId);
		}

		Long ldapServerId = (Long)attributes.get("ldapServerId");

		if (ldapServerId != null) {
			setLdapServerId(ldapServerId);
		}

		String openId = (String)attributes.get("openId");

		if (openId != null) {
			setOpenId(openId);
		}

		Long portraitId = (Long)attributes.get("portraitId");

		if (portraitId != null) {
			setPortraitId(portraitId);
		}

		String languageId = (String)attributes.get("languageId");

		if (languageId != null) {
			setLanguageId(languageId);
		}

		String timeZoneId = (String)attributes.get("timeZoneId");

		if (timeZoneId != null) {
			setTimeZoneId(timeZoneId);
		}

		String greeting = (String)attributes.get("greeting");

		if (greeting != null) {
			setGreeting(greeting);
		}

		String comments = (String)attributes.get("comments");

		if (comments != null) {
			setComments(comments);
		}

		String firstName = (String)attributes.get("firstName");

		if (firstName != null) {
			setFirstName(firstName);
		}

		String middleName = (String)attributes.get("middleName");

		if (middleName != null) {
			setMiddleName(middleName);
		}

		String lastName = (String)attributes.get("lastName");

		if (lastName != null) {
			setLastName(lastName);
		}

		String jobTitle = (String)attributes.get("jobTitle");

		if (jobTitle != null) {
			setJobTitle(jobTitle);
		}

		Date loginDate = (Date)attributes.get("loginDate");

		if (loginDate != null) {
			setLoginDate(loginDate);
		}

		String loginIP = (String)attributes.get("loginIP");

		if (loginIP != null) {
			setLoginIP(loginIP);
		}

		Date lastLoginDate = (Date)attributes.get("lastLoginDate");

		if (lastLoginDate != null) {
			setLastLoginDate(lastLoginDate);
		}

		String lastLoginIP = (String)attributes.get("lastLoginIP");

		if (lastLoginIP != null) {
			setLastLoginIP(lastLoginIP);
		}

		Date lastFailedLoginDate = (Date)attributes.get("lastFailedLoginDate");

		if (lastFailedLoginDate != null) {
			setLastFailedLoginDate(lastFailedLoginDate);
		}

		Integer failedLoginAttempts = (Integer)attributes.get(
				"failedLoginAttempts");

		if (failedLoginAttempts != null) {
			setFailedLoginAttempts(failedLoginAttempts);
		}

		Boolean lockout = (Boolean)attributes.get("lockout");

		if (lockout != null) {
			setLockout(lockout);
		}

		Date lockoutDate = (Date)attributes.get("lockoutDate");

		if (lockoutDate != null) {
			setLockoutDate(lockoutDate);
		}

		Boolean agreedToTermsOfUse = (Boolean)attributes.get(
				"agreedToTermsOfUse");

		if (agreedToTermsOfUse != null) {
			setAgreedToTermsOfUse(agreedToTermsOfUse);
		}

		Boolean emailAddressVerified = (Boolean)attributes.get(
				"emailAddressVerified");

		if (emailAddressVerified != null) {
			setEmailAddressVerified(emailAddressVerified);
		}

		Integer status = (Integer)attributes.get("status");

		if (status != null) {
			setStatus(status);
		}
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return StringPool.BLANK;
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}

	@Override
	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask |= CREATEDATE_COLUMN_BITMASK;

		if (_originalCreateDate == null) {
			_originalCreateDate = _createDate;
		}

		_createDate = createDate;
	}

	public Date getOriginalCreateDate() {
		return _originalCreateDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_columnBitmask |= MODIFIEDDATE_COLUMN_BITMASK;

		if (_originalModifiedDate == null) {
			_originalModifiedDate = _modifiedDate;
		}

		_modifiedDate = modifiedDate;
	}

	public Date getOriginalModifiedDate() {
		return _originalModifiedDate;
	}

	@JSON
	@Override
	public boolean getDefaultUser() {
		return _defaultUser;
	}

	@Override
	public boolean isDefaultUser() {
		return _defaultUser;
	}

	@Override
	public void setDefaultUser(boolean defaultUser) {
		_columnBitmask |= DEFAULTUSER_COLUMN_BITMASK;

		if (!_setOriginalDefaultUser) {
			_setOriginalDefaultUser = true;

			_originalDefaultUser = _defaultUser;
		}

		_defaultUser = defaultUser;
	}

	public boolean getOriginalDefaultUser() {
		return _originalDefaultUser;
	}

	@JSON
	@Override
	public long getContactId() {
		return _contactId;
	}

	@Override
	public void setContactId(long contactId) {
		_columnBitmask |= CONTACTID_COLUMN_BITMASK;

		if (!_setOriginalContactId) {
			_setOriginalContactId = true;

			_originalContactId = _contactId;
		}

		_contactId = contactId;
	}

	public long getOriginalContactId() {
		return _originalContactId;
	}

	@JSON(include = false)
	@Override
	public String getPassword() {
		if (_password == null) {
			return StringPool.BLANK;
		}
		else {
			return _password;
		}
	}

	@Override
	public void setPassword(String password) {
		_password = password;
	}

	@JSON(include = false)
	@Override
	public boolean getPasswordEncrypted() {
		return _passwordEncrypted;
	}

	@Override
	public boolean isPasswordEncrypted() {
		return _passwordEncrypted;
	}

	@Override
	public void setPasswordEncrypted(boolean passwordEncrypted) {
		_passwordEncrypted = passwordEncrypted;
	}

	@JSON(include = false)
	@Override
	public boolean getPasswordReset() {
		return _passwordReset;
	}

	@Override
	public boolean isPasswordReset() {
		return _passwordReset;
	}

	@Override
	public void setPasswordReset(boolean passwordReset) {
		_passwordReset = passwordReset;
	}

	@JSON(include = false)
	@Override
	public Date getPasswordModifiedDate() {
		return _passwordModifiedDate;
	}

	@Override
	public void setPasswordModifiedDate(Date passwordModifiedDate) {
		_passwordModifiedDate = passwordModifiedDate;
	}

	@JSON(include = false)
	@Override
	public String getDigest() {
		if (_digest == null) {
			return StringPool.BLANK;
		}
		else {
			return _digest;
		}
	}

	@Override
	public void setDigest(String digest) {
		_digest = digest;
	}

	@JSON
	@Override
	public String getReminderQueryQuestion() {
		if (_reminderQueryQuestion == null) {
			return StringPool.BLANK;
		}
		else {
			return _reminderQueryQuestion;
		}
	}

	@Override
	public void setReminderQueryQuestion(String reminderQueryQuestion) {
		_reminderQueryQuestion = reminderQueryQuestion;
	}

	@JSON
	@Override
	public String getReminderQueryAnswer() {
		if (_reminderQueryAnswer == null) {
			return StringPool.BLANK;
		}
		else {
			return _reminderQueryAnswer;
		}
	}

	@Override
	public void setReminderQueryAnswer(String reminderQueryAnswer) {
		_reminderQueryAnswer = reminderQueryAnswer;
	}

	@JSON
	@Override
	public int getGraceLoginCount() {
		return _graceLoginCount;
	}

	@Override
	public void setGraceLoginCount(int graceLoginCount) {
		_graceLoginCount = graceLoginCount;
	}

	@JSON
	@Override
	public String getScreenName() {
		if (_screenName == null) {
			return StringPool.BLANK;
		}
		else {
			return _screenName;
		}
	}

	@Override
	public void setScreenName(String screenName) {
		_columnBitmask |= SCREENNAME_COLUMN_BITMASK;

		if (_originalScreenName == null) {
			_originalScreenName = _screenName;
		}

		_screenName = screenName;
	}

	public String getOriginalScreenName() {
		return GetterUtil.getString(_originalScreenName);
	}

	@JSON
	@Override
	public String getEmailAddress() {
		if (_emailAddress == null) {
			return StringPool.BLANK;
		}
		else {
			return _emailAddress;
		}
	}

	@Override
	public void setEmailAddress(String emailAddress) {
		_columnBitmask |= EMAILADDRESS_COLUMN_BITMASK;

		if (_originalEmailAddress == null) {
			_originalEmailAddress = _emailAddress;
		}

		_emailAddress = emailAddress;
	}

	public String getOriginalEmailAddress() {
		return GetterUtil.getString(_originalEmailAddress);
	}

	@JSON
	@Override
	public long getFacebookId() {
		return _facebookId;
	}

	@Override
	public void setFacebookId(long facebookId) {
		_columnBitmask |= FACEBOOKID_COLUMN_BITMASK;

		if (!_setOriginalFacebookId) {
			_setOriginalFacebookId = true;

			_originalFacebookId = _facebookId;
		}

		_facebookId = facebookId;
	}

	public long getOriginalFacebookId() {
		return _originalFacebookId;
	}

	@JSON
	@Override
	public long getLdapServerId() {
		return _ldapServerId;
	}

	@Override
	public void setLdapServerId(long ldapServerId) {
		_ldapServerId = ldapServerId;
	}

	@JSON
	@Override
	public String getOpenId() {
		if (_openId == null) {
			return StringPool.BLANK;
		}
		else {
			return _openId;
		}
	}

	@Override
	public void setOpenId(String openId) {
		_columnBitmask |= OPENID_COLUMN_BITMASK;

		if (_originalOpenId == null) {
			_originalOpenId = _openId;
		}

		_openId = openId;
	}

	public String getOriginalOpenId() {
		return GetterUtil.getString(_originalOpenId);
	}

	@JSON
	@Override
	public long getPortraitId() {
		return _portraitId;
	}

	@Override
	public void setPortraitId(long portraitId) {
		_columnBitmask |= PORTRAITID_COLUMN_BITMASK;

		if (!_setOriginalPortraitId) {
			_setOriginalPortraitId = true;

			_originalPortraitId = _portraitId;
		}

		_portraitId = portraitId;
	}

	public long getOriginalPortraitId() {
		return _originalPortraitId;
	}

	@JSON
	@Override
	public String getLanguageId() {
		if (_languageId == null) {
			return StringPool.BLANK;
		}
		else {
			return _languageId;
		}
	}

	@Override
	public void setLanguageId(String languageId) {
		_languageId = languageId;
	}

	@JSON
	@Override
	public String getTimeZoneId() {
		if (_timeZoneId == null) {
			return StringPool.BLANK;
		}
		else {
			return _timeZoneId;
		}
	}

	@Override
	public void setTimeZoneId(String timeZoneId) {
		_timeZoneId = timeZoneId;
	}

	@JSON
	@Override
	public String getGreeting() {
		if (_greeting == null) {
			return StringPool.BLANK;
		}
		else {
			return _greeting;
		}
	}

	@Override
	public void setGreeting(String greeting) {
		_greeting = greeting;
	}

	@JSON
	@Override
	public String getComments() {
		if (_comments == null) {
			return StringPool.BLANK;
		}
		else {
			return _comments;
		}
	}

	@Override
	public void setComments(String comments) {
		_comments = comments;
	}

	@JSON
	@Override
	public String getFirstName() {
		if (_firstName == null) {
			return StringPool.BLANK;
		}
		else {
			return _firstName;
		}
	}

	@Override
	public void setFirstName(String firstName) {
		_firstName = firstName;
	}

	@JSON
	@Override
	public String getMiddleName() {
		if (_middleName == null) {
			return StringPool.BLANK;
		}
		else {
			return _middleName;
		}
	}

	@Override
	public void setMiddleName(String middleName) {
		_middleName = middleName;
	}

	@JSON
	@Override
	public String getLastName() {
		if (_lastName == null) {
			return StringPool.BLANK;
		}
		else {
			return _lastName;
		}
	}

	@Override
	public void setLastName(String lastName) {
		_lastName = lastName;
	}

	@JSON
	@Override
	public String getJobTitle() {
		if (_jobTitle == null) {
			return StringPool.BLANK;
		}
		else {
			return _jobTitle;
		}
	}

	@Override
	public void setJobTitle(String jobTitle) {
		_jobTitle = jobTitle;
	}

	@JSON
	@Override
	public Date getLoginDate() {
		return _loginDate;
	}

	@Override
	public void setLoginDate(Date loginDate) {
		_loginDate = loginDate;
	}

	@JSON
	@Override
	public String getLoginIP() {
		if (_loginIP == null) {
			return StringPool.BLANK;
		}
		else {
			return _loginIP;
		}
	}

	@Override
	public void setLoginIP(String loginIP) {
		_loginIP = loginIP;
	}

	@JSON
	@Override
	public Date getLastLoginDate() {
		return _lastLoginDate;
	}

	@Override
	public void setLastLoginDate(Date lastLoginDate) {
		_lastLoginDate = lastLoginDate;
	}

	@JSON
	@Override
	public String getLastLoginIP() {
		if (_lastLoginIP == null) {
			return StringPool.BLANK;
		}
		else {
			return _lastLoginIP;
		}
	}

	@Override
	public void setLastLoginIP(String lastLoginIP) {
		_lastLoginIP = lastLoginIP;
	}

	@JSON
	@Override
	public Date getLastFailedLoginDate() {
		return _lastFailedLoginDate;
	}

	@Override
	public void setLastFailedLoginDate(Date lastFailedLoginDate) {
		_lastFailedLoginDate = lastFailedLoginDate;
	}

	@JSON
	@Override
	public int getFailedLoginAttempts() {
		return _failedLoginAttempts;
	}

	@Override
	public void setFailedLoginAttempts(int failedLoginAttempts) {
		_failedLoginAttempts = failedLoginAttempts;
	}

	@JSON
	@Override
	public boolean getLockout() {
		return _lockout;
	}

	@Override
	public boolean isLockout() {
		return _lockout;
	}

	@Override
	public void setLockout(boolean lockout) {
		_lockout = lockout;
	}

	@JSON
	@Override
	public Date getLockoutDate() {
		return _lockoutDate;
	}

	@Override
	public void setLockoutDate(Date lockoutDate) {
		_lockoutDate = lockoutDate;
	}

	@JSON
	@Override
	public boolean getAgreedToTermsOfUse() {
		return _agreedToTermsOfUse;
	}

	@Override
	public boolean isAgreedToTermsOfUse() {
		return _agreedToTermsOfUse;
	}

	@Override
	public void setAgreedToTermsOfUse(boolean agreedToTermsOfUse) {
		_agreedToTermsOfUse = agreedToTermsOfUse;
	}

	@JSON
	@Override
	public boolean getEmailAddressVerified() {
		return _emailAddressVerified;
	}

	@Override
	public boolean isEmailAddressVerified() {
		return _emailAddressVerified;
	}

	@Override
	public void setEmailAddressVerified(boolean emailAddressVerified) {
		_emailAddressVerified = emailAddressVerified;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(PortalUtil.getClassNameId(
				User.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			User.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public User toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (User)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		UserImpl userImpl = new UserImpl();

		userImpl.setUuid(getUuid());
		userImpl.setUserId(getUserId());
		userImpl.setCompanyId(getCompanyId());
		userImpl.setCreateDate(getCreateDate());
		userImpl.setModifiedDate(getModifiedDate());
		userImpl.setDefaultUser(getDefaultUser());
		userImpl.setContactId(getContactId());
		userImpl.setPassword(getPassword());
		userImpl.setPasswordEncrypted(getPasswordEncrypted());
		userImpl.setPasswordReset(getPasswordReset());
		userImpl.setPasswordModifiedDate(getPasswordModifiedDate());
		userImpl.setDigest(getDigest());
		userImpl.setReminderQueryQuestion(getReminderQueryQuestion());
		userImpl.setReminderQueryAnswer(getReminderQueryAnswer());
		userImpl.setGraceLoginCount(getGraceLoginCount());
		userImpl.setScreenName(getScreenName());
		userImpl.setEmailAddress(getEmailAddress());
		userImpl.setFacebookId(getFacebookId());
		userImpl.setLdapServerId(getLdapServerId());
		userImpl.setOpenId(getOpenId());
		userImpl.setPortraitId(getPortraitId());
		userImpl.setLanguageId(getLanguageId());
		userImpl.setTimeZoneId(getTimeZoneId());
		userImpl.setGreeting(getGreeting());
		userImpl.setComments(getComments());
		userImpl.setFirstName(getFirstName());
		userImpl.setMiddleName(getMiddleName());
		userImpl.setLastName(getLastName());
		userImpl.setJobTitle(getJobTitle());
		userImpl.setLoginDate(getLoginDate());
		userImpl.setLoginIP(getLoginIP());
		userImpl.setLastLoginDate(getLastLoginDate());
		userImpl.setLastLoginIP(getLastLoginIP());
		userImpl.setLastFailedLoginDate(getLastFailedLoginDate());
		userImpl.setFailedLoginAttempts(getFailedLoginAttempts());
		userImpl.setLockout(getLockout());
		userImpl.setLockoutDate(getLockoutDate());
		userImpl.setAgreedToTermsOfUse(getAgreedToTermsOfUse());
		userImpl.setEmailAddressVerified(getEmailAddressVerified());
		userImpl.setStatus(getStatus());

		userImpl.resetOriginalValues();

		return userImpl;
	}

	@Override
	public int compareTo(User user) {
		long primaryKey = user.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof User)) {
			return false;
		}

		User user = (User)obj;

		long primaryKey = user.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public void resetOriginalValues() {
		UserModelImpl userModelImpl = this;

		userModelImpl._originalUuid = userModelImpl._uuid;

		userModelImpl._originalUserId = userModelImpl._userId;

		userModelImpl._setOriginalUserId = false;

		userModelImpl._originalCompanyId = userModelImpl._companyId;

		userModelImpl._setOriginalCompanyId = false;

		userModelImpl._originalCreateDate = userModelImpl._createDate;

		userModelImpl._originalModifiedDate = userModelImpl._modifiedDate;

		userModelImpl._originalDefaultUser = userModelImpl._defaultUser;

		userModelImpl._setOriginalDefaultUser = false;

		userModelImpl._originalContactId = userModelImpl._contactId;

		userModelImpl._setOriginalContactId = false;

		userModelImpl._originalScreenName = userModelImpl._screenName;

		userModelImpl._originalEmailAddress = userModelImpl._emailAddress;

		userModelImpl._originalFacebookId = userModelImpl._facebookId;

		userModelImpl._setOriginalFacebookId = false;

		userModelImpl._originalOpenId = userModelImpl._openId;

		userModelImpl._originalPortraitId = userModelImpl._portraitId;

		userModelImpl._setOriginalPortraitId = false;

		userModelImpl._originalStatus = userModelImpl._status;

		userModelImpl._setOriginalStatus = false;

		userModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<User> toCacheModel() {
		UserCacheModel userCacheModel = new UserCacheModel();

		userCacheModel.uuid = getUuid();

		String uuid = userCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			userCacheModel.uuid = null;
		}

		userCacheModel.userId = getUserId();

		userCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			userCacheModel.createDate = createDate.getTime();
		}
		else {
			userCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			userCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			userCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		userCacheModel.defaultUser = getDefaultUser();

		userCacheModel.contactId = getContactId();

		userCacheModel.password = getPassword();

		String password = userCacheModel.password;

		if ((password != null) && (password.length() == 0)) {
			userCacheModel.password = null;
		}

		userCacheModel.passwordEncrypted = getPasswordEncrypted();

		userCacheModel.passwordReset = getPasswordReset();

		Date passwordModifiedDate = getPasswordModifiedDate();

		if (passwordModifiedDate != null) {
			userCacheModel.passwordModifiedDate = passwordModifiedDate.getTime();
		}
		else {
			userCacheModel.passwordModifiedDate = Long.MIN_VALUE;
		}

		userCacheModel.digest = getDigest();

		String digest = userCacheModel.digest;

		if ((digest != null) && (digest.length() == 0)) {
			userCacheModel.digest = null;
		}

		userCacheModel.reminderQueryQuestion = getReminderQueryQuestion();

		String reminderQueryQuestion = userCacheModel.reminderQueryQuestion;

		if ((reminderQueryQuestion != null) &&
				(reminderQueryQuestion.length() == 0)) {
			userCacheModel.reminderQueryQuestion = null;
		}

		userCacheModel.reminderQueryAnswer = getReminderQueryAnswer();

		String reminderQueryAnswer = userCacheModel.reminderQueryAnswer;

		if ((reminderQueryAnswer != null) &&
				(reminderQueryAnswer.length() == 0)) {
			userCacheModel.reminderQueryAnswer = null;
		}

		userCacheModel.graceLoginCount = getGraceLoginCount();

		userCacheModel.screenName = getScreenName();

		String screenName = userCacheModel.screenName;

		if ((screenName != null) && (screenName.length() == 0)) {
			userCacheModel.screenName = null;
		}

		userCacheModel.emailAddress = getEmailAddress();

		String emailAddress = userCacheModel.emailAddress;

		if ((emailAddress != null) && (emailAddress.length() == 0)) {
			userCacheModel.emailAddress = null;
		}

		userCacheModel.facebookId = getFacebookId();

		userCacheModel.ldapServerId = getLdapServerId();

		userCacheModel.openId = getOpenId();

		String openId = userCacheModel.openId;

		if ((openId != null) && (openId.length() == 0)) {
			userCacheModel.openId = null;
		}

		userCacheModel.portraitId = getPortraitId();

		userCacheModel.languageId = getLanguageId();

		String languageId = userCacheModel.languageId;

		if ((languageId != null) && (languageId.length() == 0)) {
			userCacheModel.languageId = null;
		}

		userCacheModel.timeZoneId = getTimeZoneId();

		String timeZoneId = userCacheModel.timeZoneId;

		if ((timeZoneId != null) && (timeZoneId.length() == 0)) {
			userCacheModel.timeZoneId = null;
		}

		userCacheModel.greeting = getGreeting();

		String greeting = userCacheModel.greeting;

		if ((greeting != null) && (greeting.length() == 0)) {
			userCacheModel.greeting = null;
		}

		userCacheModel.comments = getComments();

		String comments = userCacheModel.comments;

		if ((comments != null) && (comments.length() == 0)) {
			userCacheModel.comments = null;
		}

		userCacheModel.firstName = getFirstName();

		String firstName = userCacheModel.firstName;

		if ((firstName != null) && (firstName.length() == 0)) {
			userCacheModel.firstName = null;
		}

		userCacheModel.middleName = getMiddleName();

		String middleName = userCacheModel.middleName;

		if ((middleName != null) && (middleName.length() == 0)) {
			userCacheModel.middleName = null;
		}

		userCacheModel.lastName = getLastName();

		String lastName = userCacheModel.lastName;

		if ((lastName != null) && (lastName.length() == 0)) {
			userCacheModel.lastName = null;
		}

		userCacheModel.jobTitle = getJobTitle();

		String jobTitle = userCacheModel.jobTitle;

		if ((jobTitle != null) && (jobTitle.length() == 0)) {
			userCacheModel.jobTitle = null;
		}

		Date loginDate = getLoginDate();

		if (loginDate != null) {
			userCacheModel.loginDate = loginDate.getTime();
		}
		else {
			userCacheModel.loginDate = Long.MIN_VALUE;
		}

		userCacheModel.loginIP = getLoginIP();

		String loginIP = userCacheModel.loginIP;

		if ((loginIP != null) && (loginIP.length() == 0)) {
			userCacheModel.loginIP = null;
		}

		Date lastLoginDate = getLastLoginDate();

		if (lastLoginDate != null) {
			userCacheModel.lastLoginDate = lastLoginDate.getTime();
		}
		else {
			userCacheModel.lastLoginDate = Long.MIN_VALUE;
		}

		userCacheModel.lastLoginIP = getLastLoginIP();

		String lastLoginIP = userCacheModel.lastLoginIP;

		if ((lastLoginIP != null) && (lastLoginIP.length() == 0)) {
			userCacheModel.lastLoginIP = null;
		}

		Date lastFailedLoginDate = getLastFailedLoginDate();

		if (lastFailedLoginDate != null) {
			userCacheModel.lastFailedLoginDate = lastFailedLoginDate.getTime();
		}
		else {
			userCacheModel.lastFailedLoginDate = Long.MIN_VALUE;
		}

		userCacheModel.failedLoginAttempts = getFailedLoginAttempts();

		userCacheModel.lockout = getLockout();

		Date lockoutDate = getLockoutDate();

		if (lockoutDate != null) {
			userCacheModel.lockoutDate = lockoutDate.getTime();
		}
		else {
			userCacheModel.lockoutDate = Long.MIN_VALUE;
		}

		userCacheModel.agreedToTermsOfUse = getAgreedToTermsOfUse();

		userCacheModel.emailAddressVerified = getEmailAddressVerified();

		userCacheModel.status = getStatus();

		return userCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(81);

		sb.append("{uuid=");
		sb.append(getUuid());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", defaultUser=");
		sb.append(getDefaultUser());
		sb.append(", contactId=");
		sb.append(getContactId());
		sb.append(", password=");
		sb.append(getPassword());
		sb.append(", passwordEncrypted=");
		sb.append(getPasswordEncrypted());
		sb.append(", passwordReset=");
		sb.append(getPasswordReset());
		sb.append(", passwordModifiedDate=");
		sb.append(getPasswordModifiedDate());
		sb.append(", digest=");
		sb.append(getDigest());
		sb.append(", reminderQueryQuestion=");
		sb.append(getReminderQueryQuestion());
		sb.append(", reminderQueryAnswer=");
		sb.append(getReminderQueryAnswer());
		sb.append(", graceLoginCount=");
		sb.append(getGraceLoginCount());
		sb.append(", screenName=");
		sb.append(getScreenName());
		sb.append(", emailAddress=");
		sb.append(getEmailAddress());
		sb.append(", facebookId=");
		sb.append(getFacebookId());
		sb.append(", ldapServerId=");
		sb.append(getLdapServerId());
		sb.append(", openId=");
		sb.append(getOpenId());
		sb.append(", portraitId=");
		sb.append(getPortraitId());
		sb.append(", languageId=");
		sb.append(getLanguageId());
		sb.append(", timeZoneId=");
		sb.append(getTimeZoneId());
		sb.append(", greeting=");
		sb.append(getGreeting());
		sb.append(", comments=");
		sb.append(getComments());
		sb.append(", firstName=");
		sb.append(getFirstName());
		sb.append(", middleName=");
		sb.append(getMiddleName());
		sb.append(", lastName=");
		sb.append(getLastName());
		sb.append(", jobTitle=");
		sb.append(getJobTitle());
		sb.append(", loginDate=");
		sb.append(getLoginDate());
		sb.append(", loginIP=");
		sb.append(getLoginIP());
		sb.append(", lastLoginDate=");
		sb.append(getLastLoginDate());
		sb.append(", lastLoginIP=");
		sb.append(getLastLoginIP());
		sb.append(", lastFailedLoginDate=");
		sb.append(getLastFailedLoginDate());
		sb.append(", failedLoginAttempts=");
		sb.append(getFailedLoginAttempts());
		sb.append(", lockout=");
		sb.append(getLockout());
		sb.append(", lockoutDate=");
		sb.append(getLockoutDate());
		sb.append(", agreedToTermsOfUse=");
		sb.append(getAgreedToTermsOfUse());
		sb.append(", emailAddressVerified=");
		sb.append(getEmailAddressVerified());
		sb.append(", status=");
		sb.append(getStatus());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(124);

		sb.append("<model><model-name>");
		sb.append("com.liferay.portal.model.User");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>uuid</column-name><column-value><![CDATA[");
		sb.append(getUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>defaultUser</column-name><column-value><![CDATA[");
		sb.append(getDefaultUser());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>contactId</column-name><column-value><![CDATA[");
		sb.append(getContactId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>password</column-name><column-value><![CDATA[");
		sb.append(getPassword());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>passwordEncrypted</column-name><column-value><![CDATA[");
		sb.append(getPasswordEncrypted());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>passwordReset</column-name><column-value><![CDATA[");
		sb.append(getPasswordReset());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>passwordModifiedDate</column-name><column-value><![CDATA[");
		sb.append(getPasswordModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>digest</column-name><column-value><![CDATA[");
		sb.append(getDigest());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>reminderQueryQuestion</column-name><column-value><![CDATA[");
		sb.append(getReminderQueryQuestion());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>reminderQueryAnswer</column-name><column-value><![CDATA[");
		sb.append(getReminderQueryAnswer());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>graceLoginCount</column-name><column-value><![CDATA[");
		sb.append(getGraceLoginCount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>screenName</column-name><column-value><![CDATA[");
		sb.append(getScreenName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>emailAddress</column-name><column-value><![CDATA[");
		sb.append(getEmailAddress());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>facebookId</column-name><column-value><![CDATA[");
		sb.append(getFacebookId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ldapServerId</column-name><column-value><![CDATA[");
		sb.append(getLdapServerId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>openId</column-name><column-value><![CDATA[");
		sb.append(getOpenId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>portraitId</column-name><column-value><![CDATA[");
		sb.append(getPortraitId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>languageId</column-name><column-value><![CDATA[");
		sb.append(getLanguageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>timeZoneId</column-name><column-value><![CDATA[");
		sb.append(getTimeZoneId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>greeting</column-name><column-value><![CDATA[");
		sb.append(getGreeting());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>comments</column-name><column-value><![CDATA[");
		sb.append(getComments());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>firstName</column-name><column-value><![CDATA[");
		sb.append(getFirstName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>middleName</column-name><column-value><![CDATA[");
		sb.append(getMiddleName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>lastName</column-name><column-value><![CDATA[");
		sb.append(getLastName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>jobTitle</column-name><column-value><![CDATA[");
		sb.append(getJobTitle());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>loginDate</column-name><column-value><![CDATA[");
		sb.append(getLoginDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>loginIP</column-name><column-value><![CDATA[");
		sb.append(getLoginIP());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>lastLoginDate</column-name><column-value><![CDATA[");
		sb.append(getLastLoginDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>lastLoginIP</column-name><column-value><![CDATA[");
		sb.append(getLastLoginIP());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>lastFailedLoginDate</column-name><column-value><![CDATA[");
		sb.append(getLastFailedLoginDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>failedLoginAttempts</column-name><column-value><![CDATA[");
		sb.append(getFailedLoginAttempts());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>lockout</column-name><column-value><![CDATA[");
		sb.append(getLockout());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>lockoutDate</column-name><column-value><![CDATA[");
		sb.append(getLockoutDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>agreedToTermsOfUse</column-name><column-value><![CDATA[");
		sb.append(getAgreedToTermsOfUse());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>emailAddressVerified</column-name><column-value><![CDATA[");
		sb.append(getEmailAddressVerified());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>status</column-name><column-value><![CDATA[");
		sb.append(getStatus());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = User.class.getClassLoader();
	private static Class<?>[] _escapedModelInterfaces = new Class[] { User.class };
	private String _uuid;
	private String _originalUuid;
	private long _userId;
	private String _userUuid;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private Date _createDate;
	private Date _originalCreateDate;
	private Date _modifiedDate;
	private Date _originalModifiedDate;
	private boolean _defaultUser;
	private boolean _originalDefaultUser;
	private boolean _setOriginalDefaultUser;
	private long _contactId;
	private long _originalContactId;
	private boolean _setOriginalContactId;
	private String _password;
	private boolean _passwordEncrypted;
	private boolean _passwordReset;
	private Date _passwordModifiedDate;
	private String _digest;
	private String _reminderQueryQuestion;
	private String _reminderQueryAnswer;
	private int _graceLoginCount;
	private String _screenName;
	private String _originalScreenName;
	private String _emailAddress;
	private String _originalEmailAddress;
	private long _facebookId;
	private long _originalFacebookId;
	private boolean _setOriginalFacebookId;
	private long _ldapServerId;
	private String _openId;
	private String _originalOpenId;
	private long _portraitId;
	private long _originalPortraitId;
	private boolean _setOriginalPortraitId;
	private String _languageId;
	private String _timeZoneId;
	private String _greeting;
	private String _comments;
	private String _firstName;
	private String _middleName;
	private String _lastName;
	private String _jobTitle;
	private Date _loginDate;
	private String _loginIP;
	private Date _lastLoginDate;
	private String _lastLoginIP;
	private Date _lastFailedLoginDate;
	private int _failedLoginAttempts;
	private boolean _lockout;
	private Date _lockoutDate;
	private boolean _agreedToTermsOfUse;
	private boolean _emailAddressVerified;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _columnBitmask;
	private User _escapedModel;
}