/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.subscription;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class CleanUpSubscriptionMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(CleanUpSubscriptionMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        long[] userIds;
        long groupId = (Long)message.get("groupId");
        long[] lArray = userIds = (long[])message.get("userIds");
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            User user = UserLocalServiceUtil.getUser((long)userId);
            this.processUser(user, groupId);
            ++n2;
        }
    }

    protected long[] getGroupIds(List<Group> groups) {
        long[] groupIds = new long[groups.size()];
        int i2 = 0;
        while (i2 < groups.size()) {
            Group group = groups.get(i2);
            groupIds[i2] = group.getGroupId();
            ++i2;
        }
        return groupIds;
    }

    protected void processAssetEntry(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        String className = subscription.getClassName();
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory != null) {
            AssetEntry assetEntry = assetRendererFactory.getAssetEntry(className, subscription.getClassPK());
            if (assetEntry.getGroupId() == groupId || !ArrayUtil.contains((long[])groupIds, (long)assetEntry.getGroupId())) {
                SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
            }
            return;
        }
    }

    protected void processLayout(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)subscription.getClassPK());
        if (!(layout == null || layout.getGroupId() != groupId && ArrayUtil.contains((long[])groupIds, (long)layout.getGroupId()))) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
        }
    }

    protected void processMBCategory(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        MBCategory mbCategory = MBCategoryLocalServiceUtil.fetchMBCategory((long)subscription.getClassPK());
        if (!(mbCategory == null || mbCategory.getGroupId() != groupId && ArrayUtil.contains((long[])groupIds, (long)mbCategory.getGroupId()))) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
            return;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)subscription.getClassPK());
        if (!(group == null || group.getGroupId() != groupId && ArrayUtil.contains((long[])groupIds, (long)group.getGroupId()))) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
        }
    }

    protected void processMBThread(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)subscription.getClassPK());
        if (!(mbThread == null || mbThread.getGroupId() != groupId && ArrayUtil.contains((long[])groupIds, (long)mbThread.getGroupId()))) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
        }
    }

    protected void processSubscription(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        String className = subscription.getClassName();
        if (className.equals(Layout.class.getName())) {
            this.processLayout(subscription, groupId, groupIds);
        } else if (className.equals(MBCategory.class.getName())) {
            this.processMBCategory(subscription, groupId, groupIds);
        } else if (className.equals(MBThread.class.getName())) {
            this.processMBThread(subscription, groupId, groupIds);
        } else if (className.equals(WikiNode.class.getName())) {
            this.processWikiNode(subscription, groupId, groupIds);
        } else if (className.equals(WorkflowInstance.class.getName())) {
            this.processWorkflowInstance(subscription, groupId, groupIds);
        } else {
            this.processAssetEntry(subscription, groupId, groupIds);
        }
        throw new PortalException();
    }

    protected void processUser(User user, long groupId) throws PortalException, SystemException {
        List groups = user.getMySiteGroups(true, -1);
        long[] groupIds = this.getGroupIds(groups);
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)user.getUserId(), (int)-1, (int)-1, null);
        for (Subscription subscription : subscriptions) {
            try {
                this.processSubscription(subscription, groupId, groupIds);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                StringBundler sb = new StringBundler(8);
                sb.append("Subscription was not removed for class name ");
                sb.append(subscription.getClassName());
                sb.append(" with class PK ");
                sb.append(subscription.getClassPK());
                sb.append(" in group ");
                sb.append(groupId);
                sb.append(" for user ");
                sb.append(subscription.getUserId());
                _log.warn((Object)sb.toString());
            }
        }
    }

    protected void processWikiNode(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        WikiNode wikiNode = WikiNodeLocalServiceUtil.fetchWikiNode((long)subscription.getClassPK());
        if (!(wikiNode == null || wikiNode.getGroupId() != groupId && ArrayUtil.contains((long[])groupIds, (long)wikiNode.getGroupId()))) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
        }
    }

    protected void processWorkflowInstance(Subscription subscription, long groupId, long[] groupIds) throws PortalException, SystemException {
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)subscription.getCompanyId(), (long)subscription.getClassPK());
        Map workflowContext = workflowInstance.getWorkflowContext();
        long workflowInstanceGroupId = GetterUtil.getLong((String)((String)workflowContext.get("groupId")));
        if (!(workflowInstanceGroupId <= 0L || workflowInstanceGroupId != groupId && ArrayUtil.contains((long[])groupIds, (long)workflowInstanceGroupId))) {
            SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
        }
    }
}

