/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfTOCEntry
extends RtfField {
    private static final byte[] TEXT_HIDDEN_ON = "\\v".getBytes();
    private static final byte[] TEXT_HIDDEN_OFF = "\\v0".getBytes();
    private static final byte[] TOC_ENTRY_PAGE_NUMBER = "\\tc".getBytes();
    private static final byte[] TOC_ENTRY_NO_PAGE_NUMBER = "\\tcn".getBytes();
    private String entry = "";
    private boolean showPageNumber = true;

    public RtfTOCEntry(String string, Font font) {
        super((RtfDocument)null, font);
        if (string != null) {
            this.entry = string;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(TEXT_HIDDEN_ON);
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            if (this.showPageNumber) {
                byteArrayOutputStream.write(TOC_ENTRY_PAGE_NUMBER);
            } else {
                byteArrayOutputStream.write(TOC_ENTRY_NO_PAGE_NUMBER);
            }
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            byteArrayOutputStream.write(this.document.filterSpecialChar(this.entry, true, false).getBytes());
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write(TEXT_HIDDEN_OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setShowPageNumber(boolean bl) {
        this.showPageNumber = bl;
    }

    protected byte[] writeFieldInstContent() throws IOException {
        return null;
    }

    protected byte[] writeFieldResultContent() throws IOException {
        return null;
    }
}

