/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb;

import com.lunatech.doclets.jax.JAXDoclet;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.JAXBConfiguration;
import com.lunatech.doclets.jax.jaxb.model.JAXBClass;
import com.lunatech.doclets.jax.jaxb.model.JAXBMember;
import com.lunatech.doclets.jax.jaxb.model.Registry;
import com.lunatech.doclets.jax.jaxb.writers.PackageListWriter;
import com.lunatech.doclets.jax.jaxb.writers.SummaryWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDoclet;
import com.sun.tools.doclets.internal.toolkit.AbstractDoclet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDoclet
extends JAXDoclet<JAXBConfiguration> {
    private static final Class<?>[] jaxbAnnotations = new Class[]{XmlRootElement.class};
    private List<JAXBClass> jaxbClasses = new LinkedList<JAXBClass>();
    private Registry registry = new Registry();

    public static int optionLength(String option) {
        if ("-matchingjaxbnamesonly".equals(option) || "-jsonconvention".equals(option)) {
            return 2;
        }
        if ("-disablejaxbmethodoutput".equals(option) || "-disablejsontypename".equals(option) || "-disablexmlexample".equals(option) || "-disablejsonexample".equals(option)) {
            return 1;
        }
        return HtmlDoclet.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        if (!HtmlDoclet.validOptions((String[][])options, (DocErrorReporter)reporter)) {
            return false;
        }
        String value = Utils.getOption(options, "-matchingjaxbnamesonly");
        try {
            if (value != null) {
                Pattern.compile(value);
            }
        }
        catch (Throwable t) {
            reporter.printError("Invalid pattern for '-matchingjaxbnamesonly' option: '" + value + "' (not a valid regex)");
            return false;
        }
        String jsonConvention = Utils.getOption(options, "-jsonconvention");
        if (!(jsonConvention == null || jsonConvention.equals("mapped") || jsonConvention.equals("jettison") || jsonConvention.equals("badgerfish"))) {
            reporter.printError("Unknown JSON convention: " + jsonConvention + " (must be one of 'jettison' (default), 'badgerfish', 'mapped')");
            return false;
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return AbstractDoclet.languageVersion();
    }

    public JAXBDoclet(RootDoc rootDoc) {
        super(rootDoc);
    }

    @Override
    protected JAXBConfiguration makeConfiguration(ConfigurationImpl configuration) {
        return new JAXBConfiguration(configuration);
    }

    public static boolean start(RootDoc rootDoc) {
        new JAXBDoclet(rootDoc).start();
        return true;
    }

    private void start() {
        ClassDoc[] classes;
        for (ClassDoc klass : classes = ((JAXBConfiguration)this.conf).parentConfiguration.root.classes()) {
            if (Utils.findAnnotatedClass(klass, jaxbAnnotations) == null) continue;
            this.handleJAXBClass(klass);
        }
        for (JAXBClass klass : this.jaxbClasses) {
            klass.write(this.conf);
        }
        new PackageListWriter(this.conf, this.registry).write();
        new SummaryWriter(this.conf, this.registry).write();
        Utils.copyResources(this.conf);
    }

    private void handleJAXBClass(ClassDoc klass) {
        if (!(this.registry.isJAXBClass(klass.qualifiedTypeName()) || klass.isPrimitive() || klass.qualifiedTypeName().startsWith("java.") || klass.isEnum())) {
            Matcher m;
            String fqName = klass.qualifiedTypeName();
            if (((JAXBConfiguration)this.conf).onlyOutputJAXBClassPackagesMatching != null && !(m = ((JAXBConfiguration)this.conf).onlyOutputJAXBClassPackagesMatching.matcher(fqName)).matches()) {
                return;
            }
            JAXBClass jaxbClass = new JAXBClass(klass, this.registry, this);
            this.jaxbClasses.add(jaxbClass);
            this.registry.addJAXBClass(jaxbClass);
            List<JAXBMember> members = jaxbClass.getMembers();
            for (JAXBMember member : members) {
                Type type = member.getJavaType();
                ClassDoc doc = type.asClassDoc();
                if (doc == null) continue;
                this.handleJAXBClass(doc);
            }
        }
    }
}

