/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.PojoTypes;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.ResourceWriter;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    static final Class<? extends Annotation>[] PreferredHttpMethods = new Class[]{GET.class, HEAD.class, POST.class, PUT.class, DELETE.class};
    Map<String, Resource> subResources = new TreeMap<String, Resource>();
    List<ResourceMethod> methods = new LinkedList<ResourceMethod>();
    String fragment;
    String fragmentWithNoRegex;
    Map<String, String> regexFragments = new HashMap<String, String>();
    private Resource parent;

    public Resource(String fragment, Resource parent) {
        this.fragment = fragment;
        this.parent = parent;
        this.parseFragment();
    }

    private void parseFragment() {
        this.fragmentWithNoRegex = Utils.removeFragmentRegexes(this.fragment, this.regexFragments);
    }

    private ResourceMethod getDocMethod() {
        for (Class<? extends Annotation> httpMethod : PreferredHttpMethods) {
            ResourceMethod method = this.getMethodForHTTPMethod(httpMethod);
            if (method == null) continue;
            return method;
        }
        if (this.methods.isEmpty() && this.subResources.size() == 1) {
            return this.subResources.values().iterator().next().getDocMethod();
        }
        return null;
    }

    private ResourceMethod getMethodForHTTPMethod(Class<? extends Annotation> type) {
        for (ResourceMethod resourceMethod : this.methods) {
            String doc;
            if (!resourceMethod.hasHTTPMethod(type) || Utils.isEmptyOrNull(doc = resourceMethod.getDoc())) continue;
            return resourceMethod;
        }
        return null;
    }

    public String getDoc() {
        ResourceMethod docMethod = this.getDocMethod();
        if (docMethod == null) {
            return "";
        }
        return docMethod.getDoc();
    }

    public Doc getJavaDoc() {
        ResourceMethod docMethod = this.getDocMethod();
        if (docMethod == null) {
            return null;
        }
        return docMethod.getJavaDoc();
    }

    public String getAbsolutePath() {
        if (this.parent != null) {
            return Utils.appendURLFragments(this.parent.getAbsolutePath(), this.getName());
        }
        return "";
    }

    private void addSubResource(String firstFragment, ResourceMethod resourceMethod) {
        Resource subResource;
        if (this.subResources.containsKey(firstFragment)) {
            subResource = this.subResources.get(firstFragment);
        } else {
            subResource = new Resource(firstFragment, this);
            this.subResources.put(firstFragment, subResource);
        }
        subResource.addResourceMethod(resourceMethod);
    }

    void addResourceMethod(ResourceMethod resourceMethod) {
        String firstFragment = Utils.getFirstURLFragment(resourceMethod.getPath().substring(this.getAbsolutePath().length()));
        if (firstFragment == null) {
            this.methods.add(resourceMethod);
        } else {
            this.addSubResource(firstFragment, resourceMethod);
        }
    }

    public void dump(int offset) {
        this.dump(offset, "+ /" + this.fragment);
        for (ResourceMethod method : this.methods) {
            this.dump(offset + 1, "+ [M]" + method.toString());
        }
        for (Resource subResource : this.subResources.values()) {
            subResource.dump(offset + 1);
        }
    }

    private void dump(int offset, String fragment) {
        for (int i = 0; i < offset; ++i) {
            System.err.print("| ");
        }
        System.err.println(fragment);
    }

    public String getName() {
        return this.fragmentWithNoRegex;
    }

    public void write(JAXRSDoclet doclet, JAXConfiguration configuration, JAXRSApplication application, PojoTypes types) {
        ResourceWriter writer = new ResourceWriter(configuration, application, this, doclet);
        writer.write(types);
        for (Resource subResource : this.subResources.values()) {
            subResource.write(doclet, configuration, application, types);
        }
    }

    public Map<String, Resource> getResources() {
        return this.subResources;
    }

    public List<ResourceMethod> getMethods() {
        return this.methods;
    }

    public boolean hasRealMethods() {
        for (ResourceMethod method : this.methods) {
            if (method.isResourceLocator()) continue;
            return true;
        }
        return false;
    }

    public Resource getParent() {
        return this.parent;
    }

    public String getPathFrom(Resource parent) {
        StringBuilder strbuf = new StringBuilder();
        Resource resource = this;
        while (resource != parent) {
            strbuf.insert(0, resource.getName());
            if ((resource = resource.getParent()) == parent) continue;
            strbuf.insert(0, "/");
        }
        return strbuf.toString();
    }

    public ResourceMethod findMethod(MethodDoc member) {
        for (ResourceMethod method : this.methods) {
            if (!JAXRSApplication.areEqual(method.getMethodDoc(), member)) continue;
            return method;
        }
        return null;
    }
}

