/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.SeeTag;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.List;

public class JAXRSHtmlDocletWriter
extends HtmlDocletWriter {
    private JAXRSApplication application;
    private JAXConfiguration config;

    public JAXRSHtmlDocletWriter(JAXRSApplication application, JAXConfiguration config, String s, String s1, String s2) throws IOException {
        super(config.parentConfiguration, s, s1, s2);
        this.application = application;
        this.config = config;
    }

    public String seeTagToString(SeeTag tag) {
        Resource res = null;
        String linkText = null;
        String hash = null;
        if (tag.referencedClassName() != null) {
            ClassDoc cDoc = tag.referencedClass();
            if (cDoc == null) {
                return this.invalidLink(tag, String.format("can't find referenced class %s", tag.referencedClassName()));
            }
            res = this.application.findResourceClass(cDoc);
            if (res != null) {
                linkText = Utils.getAbsolutePath(this.config, res);
            }
            if (res != null && tag.referencedMemberName() != null) {
                ResourceMethod rMethod;
                MemberDoc member = tag.referencedMember();
                if (member == null) {
                    return this.invalidLink(tag, String.format("can't find resource method %s in %s", tag.referencedMemberName(), cDoc.qualifiedName()));
                }
                if (member instanceof MethodDoc && (res = this.application.findResourceForMethod(cDoc, (MethodDoc)member)) != null && (rMethod = res.findMethod((MethodDoc)member)) != null) {
                    linkText = this.getDisplayText(res, rMethod);
                    hash = rMethod.getMethods().get(0);
                }
            }
        }
        if (res != null) {
            String linkTitle;
            if (tag.label() != null && !tag.label().trim().isEmpty()) {
                linkTitle = linkText;
                linkText = tag.label();
            } else {
                linkTitle = "";
            }
            String path = Utils.urlToPath(res);
            if (path.length() == 0) {
                path = ".";
            }
            String link = this.relativePath + path + "/index.html";
            if (hash != null) {
                link = link + "#" + hash;
            }
            return String.format("<tt><a href='%s' title='%s'>%s</a></tt>", link, linkTitle, linkText);
        }
        return super.seeTagToString(tag);
    }

    private String getDisplayText(Resource resource, ResourceMethod rMethod) {
        StringBuilder sb = new StringBuilder();
        if (!rMethod.isResourceLocator()) {
            List<String> methods = rMethod.getMethods();
            for (int i = 0; i < methods.size(); ++i) {
                sb.append(methods.get(i));
                if (i >= methods.size() - 1) continue;
                sb.append("/");
            }
            sb.append(" ");
        }
        sb.append(Utils.getAbsolutePath(this.config, resource));
        return sb.toString();
    }

    private String invalidLink(SeeTag tag, String msg) {
        this.config.parentConfiguration.root.printWarning(tag.position(), "Tag " + tag.name() + ": " + msg);
        return String.format("<code class='invalid-link'>%s</code>", tag.text());
    }

    public JAXRSApplication getApplication() {
        return this.application;
    }
}

