/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.JAXRSHtmlDocletWriter;
import com.sun.javadoc.Doc;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.Map;

public class SummaryWriter
extends DocletWriter {
    public SummaryWriter(JAXConfiguration configuration, JAXRSApplication application, JAXRSDoclet doclet) {
        super(configuration, SummaryWriter.getWriter(configuration, application), application, application.getRootResource(), doclet);
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, JAXRSApplication application) {
        try {
            return new JAXRSHtmlDocletWriter(application, configuration, "", "overview-summary.html", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.printPrelude("Overview of resources", "Overview");
        this.printResources();
        this.tag("hr");
        this.printPostlude("Overview");
        this.writer.flush();
        this.writer.close();
    }

    private void printResources() {
        this.tag("hr");
        this.open("table class='info'");
        this.around("caption class='TableCaption'", "Resources");
        this.open("tbody");
        this.open("tr class='subheader'");
        this.around("th class='TableHeader'", "Resource");
        this.around("th class='TableHeader'", "Description");
        this.around("th class='TableHeader'", "Methods");
        this.close("tr");
        this.printResource(this.resource);
        this.close("tbody");
        this.close("table");
    }

    private void printResource(Resource resource) {
        if (resource.hasRealMethods()) {
            this.printResourceLine(resource);
        }
        Map<String, Resource> subResources = resource.getResources();
        for (String name : subResources.keySet()) {
            Resource subResource = subResources.get(name);
            this.printResource(subResource);
        }
    }

    private void printResourceLine(Resource resource) {
        this.open("tr");
        this.open("td");
        String path = Utils.urlToPath(resource);
        if (path.length() == 0) {
            path = ".";
        }
        this.open("a href='" + path + "/index.html'");
        this.around("tt", Utils.getAbsolutePath(this, resource));
        this.close("a");
        this.close("td");
        this.open("td");
        Doc javaDoc = resource.getJavaDoc();
        if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
            this.writer.printSummaryComment(javaDoc);
        }
        this.close("td");
        this.open("td");
        boolean first = true;
        for (ResourceMethod method : resource.getMethods()) {
            for (String httpMethod : method.getMethods()) {
                if (!first) {
                    this.print(", ");
                }
                this.open("a href='" + path + "/index.html#" + httpMethod + "'");
                this.around("tt", httpMethod);
                this.close("a");
                first = false;
            }
        }
        this.close("td");
        this.close("tr");
    }

    protected void printHeader() {
        this.printHeader("Overview of resources");
    }
}

