/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.zip.Inflater;
import org.eclipse.jgit.lib.InflaterFactory;

public class InflaterCache {
    private static final int SZ = 4;
    public static InflaterFactory INFLATER_FACTORY = InflaterFactory.STANDARD_FACTORY;
    private static final Inflater[] inflaterCache = new Inflater[4];
    private static int openInflaterCount;

    public static Inflater get() {
        Inflater r = InflaterCache.getImpl();
        return r != null ? r : INFLATER_FACTORY.create();
    }

    private static synchronized Inflater getImpl() {
        if (openInflaterCount > 0) {
            Inflater r = inflaterCache[--openInflaterCount];
            InflaterCache.inflaterCache[InflaterCache.openInflaterCount] = null;
            return r;
        }
        return null;
    }

    public static void release(Inflater i) {
        if (i != null) {
            i.reset();
            if (InflaterCache.releaseImpl(i)) {
                INFLATER_FACTORY.decommision(i);
            }
        }
    }

    private static synchronized boolean releaseImpl(Inflater i) {
        if (openInflaterCount < 4) {
            InflaterCache.inflaterCache[InflaterCache.openInflaterCount++] = i;
            return false;
        }
        return true;
    }

    private InflaterCache() {
        throw new UnsupportedOperationException();
    }
}

