/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;
import org.eclipse.jgit.util.io.StreamCopyThread;

class TransportLocal
extends Transport
implements PackTransport {
    static final TransportProtocol PROTO_LOCAL = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoLocal;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("file");
        }

        @Override
        public boolean canHandle(URIish uri, Repository local, String remoteName) {
            return uri.getPath() != null && uri.getPort() <= 0 && uri.getUser() == null && uri.getPass() == null && uri.getHost() == null && (uri.getScheme() == null || this.getSchemes().contains(uri.getScheme()));
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NoRemoteRepositoryException {
            File localPath = local.isBare() ? local.getDirectory() : local.getWorkTree();
            File path = local.getFS().resolve(localPath, uri.getPath());
            if (path.isFile()) {
                return new TransportBundleFile(local, uri, path);
            }
            File gitDir = RepositoryCache.FileKey.resolve(path, local.getFS());
            if (gitDir == null) {
                throw new NoRemoteRepositoryException(uri, JGitText.get().notFound);
            }
            return new TransportLocal(local, uri, gitDir);
        }
    };
    private final File remoteGitDir;

    TransportLocal(Repository local, URIish uri, File gitDir) {
        super(local, uri);
        this.remoteGitDir = gitDir;
    }

    UploadPack createUploadPack(Repository dst) {
        return new UploadPack(dst);
    }

    ReceivePack createReceivePack(Repository dst) {
        return new ReceivePack(dst);
    }

    public FetchConnection openFetch() throws TransportException {
        String up = this.getOptionUploadPack();
        if ("git-upload-pack".equals(up) || "git upload-pack".equals(up)) {
            return new InternalLocalFetchConnection();
        }
        return new ForkLocalFetchConnection();
    }

    public PushConnection openPush() throws NotSupportedException, TransportException {
        String rp = this.getOptionReceivePack();
        if ("git-receive-pack".equals(rp) || "git receive-pack".equals(rp)) {
            return new InternalLocalPushConnection();
        }
        return new ForkLocalPushConnection();
    }

    public void close() {
    }

    protected Process spawn(String cmd) throws TransportException {
        try {
            String[] args = new String[]{"."};
            ProcessBuilder proc = this.local.getFS().runInShell(cmd, args);
            proc.directory(this.remoteGitDir);
            Map<String, String> env = proc.environment();
            env.remove("GIT_ALTERNATE_OBJECT_DIRECTORIES");
            env.remove("GIT_CONFIG");
            env.remove("GIT_CONFIG_PARAMETERS");
            env.remove("GIT_DIR");
            env.remove("GIT_WORK_TREE");
            env.remove("GIT_GRAFT_FILE");
            env.remove("GIT_INDEX_FILE");
            env.remove("GIT_NO_REPLACE_OBJECTS");
            return proc.start();
        }
        catch (IOException err) {
            throw new TransportException(this.uri, err.getMessage(), err);
        }
    }

    class ForkLocalPushConnection
    extends BasePackPushConnection {
        private Process receivePack;
        private Thread errorReaderThread;

        ForkLocalPushConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.receivePack = TransportLocal.this.spawn(TransportLocal.this.getOptionReceivePack());
            InputStream rpErr = this.receivePack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(rpErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream rpIn = this.receivePack.getInputStream();
            OutputStream rpOut = this.receivePack.getOutputStream();
            rpIn = new BufferedInputStream(rpIn);
            rpOut = new SafeBufferedOutputStream(rpOut);
            this.init(rpIn, rpOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.receivePack != null) {
                try {
                    this.receivePack.waitFor();
                }
                catch (InterruptedException ie) {
                }
                finally {
                    this.receivePack = null;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    this.errorReaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.errorReaderThread = null;
                }
            }
        }
    }

    class InternalLocalPushConnection
    extends BasePackPushConnection {
        private Thread worker;

        InternalLocalPushConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            Object dst;
            super(TransportLocal.this);
            try {
                dst = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(TransportLocal.this.remoteGitDir)).build();
            }
            catch (IOException err) {
                throw new TransportException(this.uri, JGitText.get().notAGitDirectory);
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream();
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                ((Repository)dst).close();
                throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
            }
            this.worker = new Thread("JGit-Receive-Pack", (Repository)dst, out_r, in_w){
                final /* synthetic */ Repository val$dst;
                final /* synthetic */ PipedInputStream val$out_r;
                final /* synthetic */ PipedOutputStream val$in_w;
                {
                    this.val$dst = repository;
                    this.val$out_r = pipedInputStream;
                    this.val$in_w = pipedOutputStream;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ReceivePack rp = TransportLocal.this.createReceivePack(this.val$dst);
                        rp.receive(this.val$out_r, this.val$in_w, System.err);
                    }
                    catch (IOException err) {
                    }
                    catch (RuntimeException err) {
                    }
                    finally {
                        try {
                            this.val$out_r.close();
                        }
                        catch (IOException e2) {}
                        try {
                            this.val$in_w.close();
                        }
                        catch (IOException e2) {}
                        this.val$dst.close();
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.worker = null;
                }
            }
        }
    }

    class ForkLocalFetchConnection
    extends BasePackFetchConnection {
        private Process uploadPack;
        private Thread errorReaderThread;

        ForkLocalFetchConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.uploadPack = TransportLocal.this.spawn(TransportLocal.this.getOptionUploadPack());
            InputStream upErr = this.uploadPack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(upErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream upIn = this.uploadPack.getInputStream();
            OutputStream upOut = this.uploadPack.getOutputStream();
            upIn = new BufferedInputStream(upIn);
            upOut = new SafeBufferedOutputStream(upOut);
            this.init(upIn, upOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.uploadPack != null) {
                try {
                    this.uploadPack.waitFor();
                }
                catch (InterruptedException ie) {
                }
                finally {
                    this.uploadPack = null;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    this.errorReaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.errorReaderThread = null;
                }
            }
        }
    }

    class InternalLocalFetchConnection
    extends BasePackFetchConnection {
        private Thread worker;

        InternalLocalFetchConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            Object dst;
            super(TransportLocal.this);
            try {
                dst = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(TransportLocal.this.remoteGitDir)).build();
            }
            catch (IOException err) {
                throw new TransportException(this.uri, JGitText.get().notAGitDirectory);
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream(){
                    {
                        this.buffer = new byte[2952];
                    }
                };
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                ((Repository)dst).close();
                throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
            }
            this.worker = new Thread("JGit-Upload-Pack", (Repository)dst, out_r, in_w){
                final /* synthetic */ Repository val$dst;
                final /* synthetic */ PipedInputStream val$out_r;
                final /* synthetic */ PipedOutputStream val$in_w;
                {
                    this.val$dst = repository;
                    this.val$out_r = pipedInputStream;
                    this.val$in_w = pipedOutputStream;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        UploadPack rp = TransportLocal.this.createUploadPack(this.val$dst);
                        rp.upload(this.val$out_r, this.val$in_w, null);
                    }
                    catch (IOException err) {
                        err.printStackTrace();
                    }
                    catch (RuntimeException err) {
                        err.printStackTrace();
                    }
                    finally {
                        try {
                            this.val$out_r.close();
                        }
                        catch (IOException e2) {}
                        try {
                            this.val$in_w.close();
                        }
                        catch (IOException e2) {}
                        this.val$dst.close();
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.worker = null;
                }
            }
        }
    }
}

