/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.IOException;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.StreamCipher;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.engines.CamelliaEngine;
import org.spongycastle.crypto.engines.DESedeEngine;
import org.spongycastle.crypto.engines.RC4Engine;
import org.spongycastle.crypto.engines.SEEDEngine;
import org.spongycastle.crypto.modes.AEADBlockCipher;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.modes.CCMBlockCipher;
import org.spongycastle.crypto.modes.GCMBlockCipher;
import org.spongycastle.crypto.modes.OCBBlockCipher;
import org.spongycastle.crypto.tls.AbstractTlsCipherFactory;
import org.spongycastle.crypto.tls.Chacha20Poly1305;
import org.spongycastle.crypto.tls.TlsAEADCipher;
import org.spongycastle.crypto.tls.TlsBlockCipher;
import org.spongycastle.crypto.tls.TlsCipher;
import org.spongycastle.crypto.tls.TlsContext;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsNullCipher;
import org.spongycastle.crypto.tls.TlsStreamCipher;
import org.spongycastle.crypto.tls.TlsUtils;

public class DefaultTlsCipherFactory
extends AbstractTlsCipherFactory {
    public TlsCipher createCipher(TlsContext context, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(context, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(context, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(context, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(context, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(context, 16, 16);
            }
            case 103: {
                return this.createCipher_AES_OCB(context, 16, 12);
            }
            case 9: {
                return this.createAESCipher(context, 32, macAlgorithm);
            }
            case 17: {
                return this.createCipher_AES_CCM(context, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(context, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(context, 32, 16);
            }
            case 104: {
                return this.createCipher_AES_OCB(context, 32, 12);
            }
            case 12: {
                return this.createCamelliaCipher(context, 16, macAlgorithm);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(context, 16, 16);
            }
            case 13: {
                return this.createCamelliaCipher(context, 32, macAlgorithm);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(context, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(context);
            }
            case 0: {
                return this.createNullCipher(context, macAlgorithm);
            }
            case 2: {
                return this.createRC4Cipher(context, 16, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(context, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsBlockCipher createAESCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsBlockCipher createCamelliaCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createCamelliaBlockCipher(), this.createCamelliaBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createChaCha20Poly1305(TlsContext context) throws IOException {
        return new Chacha20Poly1305(context);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_CCM(), this.createAEADBlockCipher_AES_CCM(), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_GCM(), this.createAEADBlockCipher_AES_GCM(), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_OCB(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_OCB(), this.createAEADBlockCipher_AES_OCB(), cipherKeySize, macSize, 2);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_Camellia_GCM(), this.createAEADBlockCipher_Camellia_GCM(), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsNullCipher(context, this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm));
    }

    protected TlsStreamCipher createRC4Cipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize, false);
    }

    protected TlsBlockCipher createSEEDCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createSEEDBlockCipher(), this.createSEEDBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 16);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_OCB() {
        return new OCBBlockCipher(this.createAESEngine(), this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return new GCMBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    protected Digest createHMACDigest(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return TlsUtils.createHash((short)1);
            }
            case 2: {
                return TlsUtils.createHash((short)2);
            }
            case 3: {
                return TlsUtils.createHash((short)4);
            }
            case 4: {
                return TlsUtils.createHash((short)5);
            }
            case 5: {
                return TlsUtils.createHash((short)6);
            }
        }
        throw new TlsFatalAlert(80);
    }
}

