/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.dto.AllowableListValues;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.mangofactory.swagger.models.dto.Parameter;
import com.mangofactory.swagger.models.dto.builder.ParameterBuilder;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import java.util.List;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;

public class OperationParameterRequestConditionReader
implements RequestMappingReader {
    @Override
    public void execute(RequestMappingContext context) {
        ParamsRequestCondition paramsCondition = context.getRequestMappingInfo().getParamsCondition();
        List parameters = (List)context.get("parameters");
        for (NameValueExpression expression : paramsCondition.getExpressions()) {
            if (expression.isNegated() || Iterables.any(this.nullToEmptyList(parameters), this.withName(expression.getName()))) continue;
            Parameter parameter = new ParameterBuilder().name(expression.getName()).description(null).defaultValue((String)expression.getValue()).required(Boolean.valueOf(true)).allowMultiple(Boolean.valueOf(false)).dataType("string").allowableValues((AllowableValues)new AllowableListValues((List)Lists.newArrayList((Object[])new String[]{(String)expression.getValue()}), "string")).parameterType("query").parameterAccess("").build();
            parameters.add(parameter);
        }
    }

    private Iterable<Parameter> nullToEmptyList(List<Parameter> parameters) {
        if (parameters == null) {
            return Lists.newArrayList();
        }
        return parameters;
    }

    private Predicate<? super Parameter> withName(final String name) {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return Objects.equal((Object)input.getName(), (Object)name);
            }
        };
    }
}

