/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.google.common.io;

import com.microsoft.applicationinsights.core.dependencies.checkerframework.checker.nullness.compatqual.NullableDecl;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.Beta;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.GwtIncompatible;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@NullableDecl File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

