/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.sampling;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.Random;

final class SamplingScoreGenerator {
    private static Random rand = new Random();

    SamplingScoreGenerator() {
    }

    public static double getSamplingScore(Telemetry telemetry) {
        double samplingScore = 0.0;
        try {
            samplingScore = telemetry.getContext().getUser().getId() != null ? (double)SamplingScoreGenerator.getSamplingHashCode(telemetry.getContext().getUser().getId()) / 2.147483647E9 : (telemetry.getContext().getOperation().getId() != null ? (double)SamplingScoreGenerator.getSamplingHashCode(telemetry.getContext().getOperation().getId()) / 2.147483647E9 : rand.nextDouble());
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to fetch sample number for telemetry, using default", new Object[0]);
            samplingScore = rand.nextDouble();
        }
        return samplingScore *= 100.0;
    }

    private static int getSamplingHashCode(String input) {
        if (StringUtils.isEmpty(input)) {
            return 0;
        }
        int hash = 5381;
        if (input.length() < 8) {
            input = input.length() < 3 ? StringUtils.repeat(input, 8 / input.length()) : (input.length() == 3 ? StringUtils.repeat(input, 4) : StringUtils.repeat(input, 2));
        }
        char[] asChars = input.toCharArray();
        for (int i = 0; i < asChars.length; ++i) {
            hash = (hash << 5) + hash + asChars[i];
        }
        return hash == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(hash);
    }
}

