/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.internal.annotation.PerformanceModule;
import com.microsoft.applicationinsights.internal.config.JvmXmlElement;
import com.microsoft.applicationinsights.internal.config.PerformanceCounterJvmSectionXmlElement;
import com.microsoft.applicationinsights.internal.config.PerformanceCountersXmlElement;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractPerformanceCounterModule;
import com.microsoft.applicationinsights.internal.perfcounter.JvmPerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterConfigurationAware;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCountersFactory;
import java.util.HashMap;
import java.util.HashSet;

@PerformanceModule(value="BuiltIn")
public final class JvmPerformanceCountersModule
extends AbstractPerformanceCounterModule
implements PerformanceCounterConfigurationAware {
    private String[] JvmPCNames = new String[]{"ThreadDeadLockDetector", "MemoryUsage", "GC"};

    public JvmPerformanceCountersModule() throws Exception {
        this(new JvmPerformanceCountersFactory());
    }

    public JvmPerformanceCountersModule(PerformanceCountersFactory factory) throws Exception {
        super(factory);
        if (!(factory instanceof JvmPerformanceCountersFactory)) {
            throw new Exception("Factory must implement windows capabilities.");
        }
    }

    @Override
    public void addConfigurationData(PerformanceCountersXmlElement configuration) {
        JvmPerformanceCountersFactory f = (JvmPerformanceCountersFactory)this.factory;
        PerformanceCounterJvmSectionXmlElement jvmSection = configuration.getJvmSection();
        if (jvmSection == null) {
            return;
        }
        if (!jvmSection.isEnabled()) {
            f.setIsEnabled(false);
            return;
        }
        HashMap<String, JvmXmlElement> jvmPcsMap = jvmSection.getJvmXmlElementsMap();
        HashSet<String> disabledJvmPCs = new HashSet<String>();
        for (String jvmPcName : this.JvmPCNames) {
            JvmXmlElement pc = jvmPcsMap.get(jvmPcName);
            if (pc == null || pc.isEnabled()) continue;
            disabledJvmPCs.add(jvmPcName);
        }
        f.setDisabledJvmPCs(disabledJvmPCs);
    }
}

