/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Splitter;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.NoSupportedProtocolsException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;

public class SSLOptionsUtil {
    public static final String APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY = "applicationinsights.ssl.protocols";
    private static final String[] DEFAULT_SUPPORTED_PROTOCOLS;
    private static final String[] DEFAULT_PROTOCOLS;

    private SSLOptionsUtil() {
    }

    private static String[] filterSupportedProtocols(Iterable<String> defaultValue, boolean reportErrors) {
        ArrayList<String> supported = new ArrayList<String>();
        for (String protocol : defaultValue) {
            try {
                SSLContext.getInstance(protocol);
                supported.add(protocol);
            }
            catch (NoSuchAlgorithmException e) {
                if (!InternalLogger.INSTANCE.isErrorEnabled() || !reportErrors) continue;
                InternalLogger.INSTANCE.error("Could not find protocol '%s': %s", protocol, ExceptionUtils.getStackTrace(e));
            }
        }
        return supported.toArray(new String[0]);
    }

    public static String[] getAllowedProtocols() {
        String rawProp = System.getProperty(APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY);
        if (rawProp == null) {
            return SSLOptionsUtil.defaultSupportedProtocols();
        }
        if (Strings.isNullOrEmpty(rawProp)) {
            if (InternalLogger.INSTANCE.isWarnEnabled()) {
                InternalLogger.INSTANCE.warn("%s specifies no protocols; using defaults: %s", APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY, Arrays.toString(DEFAULT_SUPPORTED_PROTOCOLS));
            }
            return SSLOptionsUtil.defaultSupportedProtocols();
        }
        Object[] customProtocols = SSLOptionsUtil.filterSupportedProtocols(Splitter.on(',').trimResults().omitEmptyStrings().split(rawProp), true);
        if (customProtocols.length == 0) {
            if (InternalLogger.INSTANCE.isErrorEnabled()) {
                InternalLogger.INSTANCE.error("%s contained no supported protocols: '%s'; using default: %s", APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY, rawProp, Arrays.toString(DEFAULT_SUPPORTED_PROTOCOLS));
            }
            return SSLOptionsUtil.defaultSupportedProtocols();
        }
        if (InternalLogger.INSTANCE.isInfoEnabled()) {
            InternalLogger.INSTANCE.info("Found %s='%s'; HTTP client will allow only these protocols", APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY, Arrays.toString(customProtocols));
        }
        return customProtocols;
    }

    private static String[] defaultSupportedProtocols() {
        if (DEFAULT_SUPPORTED_PROTOCOLS.length == 0) {
            throw new NoSupportedProtocolsException(String.format("None of the default TLS protocols are supported by this JVM: %s. Use the system property '%s' to override.", Arrays.toString(DEFAULT_PROTOCOLS), APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY));
        }
        return DEFAULT_SUPPORTED_PROTOCOLS;
    }

    static {
        DEFAULT_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
        DEFAULT_SUPPORTED_PROTOCOLS = SSLOptionsUtil.filterSupportedProtocols(Arrays.asList(DEFAULT_PROTOCOLS), false);
        if (DEFAULT_SUPPORTED_PROTOCOLS.length == 0 && InternalLogger.INSTANCE.isErrorEnabled()) {
            InternalLogger.INSTANCE.error("Default protocols are not supported in this JVM: %s. System property '%s' can be used to configure supported SSL protocols.", Arrays.toString(DEFAULT_PROTOCOLS), APPLICATION_INSIGHTS_SSL_PROTOCOLS_PROPERTY);
        }
    }
}

