/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.extensibility.context.ContextTagKeys;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

class ContextTagsMap
implements ConcurrentMap<String, String> {
    private static final Map<String, Integer> tagSizeLimits = ContextTagsMap.tagSizeLimits();
    private final ConcurrentMap<String, String> tags = new ConcurrentHashMap<String, String>();

    ContextTagsMap() {
    }

    private static String truncate(String value, int maxLength) {
        if (value != null && value.length() > maxLength) {
            value = value.substring(0, maxLength);
        }
        return value;
    }

    private static String sanitizeValue(String key, String value) {
        if (value != null) {
            value = value.trim();
        }
        if (tagSizeLimits.containsKey(key)) {
            value = ContextTagsMap.truncate(value, tagSizeLimits.get(key));
        }
        return value;
    }

    @Override
    @Nullable
    public String putIfAbsent(String key, String value) {
        return this.tags.putIfAbsent(key, ContextTagsMap.sanitizeValue(key, value));
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        return this.tags.replace(key, oldValue, ContextTagsMap.sanitizeValue(key, newValue));
    }

    @Override
    @Nullable
    public String replace(String key, String value) {
        return this.tags.replace(key, ContextTagsMap.sanitizeValue(key, value));
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tags.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.tags.containsValue(value);
    }

    @Override
    @Nullable
    public String get(Object key) {
        return (String)this.tags.get(key);
    }

    @Override
    @Nullable
    public String put(String key, String value) {
        return this.tags.put(key, ContextTagsMap.sanitizeValue(key, value));
    }

    @Override
    @Nullable
    public String remove(Object key) {
        return (String)this.tags.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.tags.remove(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        HashMap<String, String> sanitized = new HashMap<String, String>();
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            sanitized.put(entry.getKey(), ContextTagsMap.sanitizeValue(entry.getKey(), entry.getValue()));
        }
        this.tags.putAll(sanitized);
    }

    @Override
    public void clear() {
        this.tags.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.tags.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.tags.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.tags.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.tags.equals(o);
    }

    @Override
    public int hashCode() {
        return this.tags.hashCode();
    }

    private static Map<String, Integer> tagSizeLimits() {
        HashMap<String, Integer> limits = new HashMap<String, Integer>();
        limits.put(ContextTagKeys.getKeys().getApplicationVersion(), 1024);
        limits.put(ContextTagKeys.getKeys().getDeviceId(), 1024);
        limits.put(ContextTagKeys.getKeys().getDeviceModel(), 256);
        limits.put(ContextTagKeys.getKeys().getDeviceOEMName(), 256);
        limits.put(ContextTagKeys.getKeys().getDeviceOSVersion(), 256);
        limits.put(ContextTagKeys.getKeys().getDeviceType(), 64);
        limits.put(ContextTagKeys.getKeys().getLocationIP(), 45);
        limits.put(ContextTagKeys.getKeys().getOperationId(), 128);
        limits.put(ContextTagKeys.getKeys().getOperationName(), 1024);
        limits.put(ContextTagKeys.getKeys().getOperationParentId(), 128);
        limits.put(ContextTagKeys.getKeys().getSyntheticSource(), 1024);
        limits.put(ContextTagKeys.getKeys().getSessionId(), 64);
        limits.put(ContextTagKeys.getKeys().getUserId(), 128);
        limits.put(ContextTagKeys.getKeys().getUserAccountId(), 1024);
        limits.put(ContextTagKeys.getKeys().getUserAuthUserId(), 1024);
        limits.put(ContextTagKeys.getKeys().getCloudRole(), 256);
        limits.put(ContextTagKeys.getKeys().getCloudRoleInstance(), 256);
        limits.put(ContextTagKeys.getKeys().getOperationCorrelationVector(), 64);
        return limits;
    }
}

