/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.containerregistry.AccessKeyType;
import com.microsoft.azure.management.containerregistry.RegistryCredentials;
import com.microsoft.azure.management.containerregistry.RegistryUsage;
import com.microsoft.azure.management.containerregistry.Sku;
import com.microsoft.azure.management.containerregistry.Webhook;
import com.microsoft.azure.management.containerregistry.WebhookOperations;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.Collection;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_1_0)
public interface Registry
extends GroupableResource<ContainerRegistryManager, RegistryInner>,
Refreshable<Registry>,
Updatable<Update> {
    public Sku sku();

    public String loginServerUrl();

    public DateTime creationDate();

    public boolean adminUserEnabled();

    public String storageAccountName();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public String storageAccountId();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    @Method
    public RegistryCredentials getCredentials();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    @Method
    public Observable<RegistryCredentials> getCredentialsAsync();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public RegistryCredentials regenerateCredential(AccessKeyType var1);

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public Observable<RegistryCredentials> regenerateCredentialAsync(AccessKeyType var1);

    @Beta(value=Beta.SinceVersion.V1_4_0)
    @Method
    public Collection<RegistryUsage> listQuotaUsages();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    @Method
    public Observable<RegistryUsage> listQuotaUsagesAsync();

    public WebhookOperations webhooks();

    public static interface UpdateStages {

        public static interface WithWebhook {
            public Webhook.UpdateDefinitionStages.Blank<Update> defineWebhook(String var1);

            public Update withoutWebhook(String var1);

            public Webhook.UpdateResourceStages.Blank<Update> updateWebhook(String var1);
        }

        public static interface WithSku {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withBasicSku();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withStandardSku();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withPremiumSku();
        }

        public static interface WithAdminUserEnabled {
            public Update withRegistryNameAsAdminUser();

            public Update withoutRegistryNameAsAdminUser();
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<Registry>,
    UpdateStages.WithAdminUserEnabled,
    UpdateStages.WithSku,
    UpdateStages.WithWebhook {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Registry>,
        WithAdminUserEnabled,
        WithWebhook,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithWebhook {
            public Webhook.DefinitionStages.Blank<WithCreate> defineWebhook(String var1);
        }

        public static interface WithAdminUserEnabled {
            public WithCreate withRegistryNameAsAdminUser();
        }

        public static interface WithStorageAccount {
            public WithCreate withExistingStorageAccount(StorageAccount var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithCreate withExistingStorageAccount(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);
        }

        public static interface WithSku {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithStorageAccount withClassicSku();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithCreate withBasicSku();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithCreate withStandardSku();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithCreate withPremiumSku();
        }

        @Beta(value=Beta.SinceVersion.V1_4_0)
        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithStorageAccount,
    DefinitionStages.WithCreate {
    }
}

