/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.CaptureDescription;
import com.microsoft.azure.management.eventhub.Destination;
import com.microsoft.azure.management.eventhub.EncodingCaptureDescription;
import com.microsoft.azure.management.eventhub.EventHub;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationRule;
import com.microsoft.azure.management.eventhub.EventHubConsumerGroup;
import com.microsoft.azure.management.eventhub.EventHubNamespace;
import com.microsoft.azure.management.eventhub.implementation.Ancestors;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.EventHubNamespaceImpl;
import com.microsoft.azure.management.eventhub.implementation.EventhubInner;
import com.microsoft.azure.management.eventhub.implementation.NestedResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

@LangDefinition
class EventHubImpl
extends NestedResourceImpl<EventHub, EventhubInner, EventHubImpl>
implements EventHub,
EventHub.Definition,
EventHub.Update {
    private Ancestors.OneAncestor ancestor;
    private CaptureSettings captureSettings;
    private StorageManager storageManager;

    EventHubImpl(String name, EventhubInner inner, EventHubManager manager, StorageManager storageManager) {
        super(name, inner, manager);
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(inner.id());
        this.captureSettings = new CaptureSettings((EventhubInner)this.inner());
        this.storageManager = storageManager;
    }

    EventHubImpl(String name, EventHubManager manager, StorageManager storageManager) {
        super(name, new EventhubInner(), manager);
        this.storageManager = storageManager;
        this.captureSettings = new CaptureSettings((EventhubInner)this.inner());
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public boolean isDataCaptureEnabled() {
        if (((EventhubInner)this.inner()).captureDescription() == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)((EventhubInner)this.inner()).captureDescription().enabled());
    }

    @Override
    public int dataCaptureWindowSizeInSeconds() {
        if (((EventhubInner)this.inner()).captureDescription() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)((EventhubInner)this.inner()).captureDescription().intervalInSeconds());
    }

    @Override
    public int dataCaptureWindowSizeInMB() {
        if (((EventhubInner)this.inner()).captureDescription() == null) {
            return 0;
        }
        int inBytes = Utils.toPrimitiveInt((Integer)((EventhubInner)this.inner()).captureDescription().sizeLimitInBytes());
        if (inBytes != 0) {
            return inBytes / 0x100000;
        }
        return 0;
    }

    @Override
    public String dataCaptureFileNameFormat() {
        if (((EventhubInner)this.inner()).captureDescription() == null) {
            return null;
        }
        if (((EventhubInner)this.inner()).captureDescription().destination() == null) {
            return null;
        }
        return ((EventhubInner)this.inner()).captureDescription().destination().archiveNameFormat();
    }

    @Override
    public Destination captureDestination() {
        if (((EventhubInner)this.inner()).captureDescription() == null) {
            return null;
        }
        return ((EventhubInner)this.inner()).captureDescription().destination();
    }

    @Override
    public Set<String> partitionIds() {
        if (((EventhubInner)this.inner()).partitionIds() == null) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return Collections.unmodifiableSet(new HashSet<String>(((EventhubInner)this.inner()).partitionIds()));
    }

    @Override
    public int messageRetentionPeriodInDays() {
        return Utils.toPrimitiveInt((Long)((EventhubInner)this.inner()).messageRetentionInDays());
    }

    @Override
    public EventHubImpl withNewNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(namespace.resourceGroupName(), namespaceCreatable.name());
        return this;
    }

    @Override
    public EventHubImpl withExistingNamespace(EventHubNamespace namespace) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(this.selfId(namespace.id()));
        return this;
    }

    @Override
    public EventHubImpl withExistingNamespace(String resourceGroupName, String namespaceName) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(resourceGroupName, namespaceName);
        return this;
    }

    @Override
    public EventHubImpl withExistingNamespaceId(String namespaceId) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.OneAncestor(this.selfId(namespaceId));
        return this;
    }

    @Override
    public EventHubImpl withNewStorageAccountForCapturedData(Creatable<StorageAccount> storageAccountCreatable, String containerName) {
        this.captureSettings.withNewStorageAccountForCapturedData(storageAccountCreatable, containerName);
        return this;
    }

    @Override
    public EventHubImpl withExistingStorageAccountForCapturedData(StorageAccount storageAccount, String containerName) {
        this.captureSettings.withExistingStorageAccountForCapturedData(storageAccount, containerName);
        return this;
    }

    @Override
    public EventHubImpl withExistingStorageAccountForCapturedData(String storageAccountId, String containerName) {
        this.captureSettings.withExistingStorageAccountForCapturedData(storageAccountId, containerName);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureEnabled() {
        this.captureSettings.withDataCaptureEnabled();
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureDisabled() {
        this.captureSettings.withDataCaptureDisabled();
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureWindowSizeInSeconds(int sizeInSeconds) {
        this.captureSettings.withDataCaptureWindowSizeInSeconds(sizeInSeconds);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureWindowSizeInMB(int sizeInMB) {
        this.captureSettings.withDataCaptureWindowSizeInMB(sizeInMB);
        return this;
    }

    @Override
    public EventHubImpl withDataCaptureFileNameFormat(String format) {
        this.captureSettings.withDataCaptureFileNameFormat(format);
        return this;
    }

    @Override
    public EventHubImpl withNewSendRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)EventHubImpl.this.manager.eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name()).withSendAccess()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withNewListenRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)EventHubImpl.this.manager.eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name()).withListenAccess()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withNewManageRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubAuthorizationRule.DefinitionStages.WithCreate)((EventHubAuthorizationRule.DefinitionStages.Blank)EventHubImpl.this.manager.eventHubAuthorizationRules().define(ruleName)).withExistingEventHub(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name()).withManageAccess()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withoutAuthorizationRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return EventHubImpl.this.manager.eventHubAuthorizationRules().deleteByNameAsync(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name(), ruleName).toObservable().concatWith(context.voidObservable());
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withNewConsumerGroup(final String name) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubConsumerGroup.DefinitionStages.Blank)EventHubImpl.this.manager.consumerGroups().define(name)).withExistingEventHub(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withNewConsumerGroup(final String name, final String metadata) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubConsumerGroup.DefinitionStages.Blank)EventHubImpl.this.manager.consumerGroups().define(name)).withExistingEventHub(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name()).withUserMetadata(metadata).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withoutConsumerGroup(final String name) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return EventHubImpl.this.manager.consumerGroups().deleteByNameAsync(EventHubImpl.this.ancestor().resourceGroupName(), EventHubImpl.this.ancestor().ancestor1Name(), EventHubImpl.this.name(), name).toObservable().concatWith(context.voidObservable());
            }
        });
        return this;
    }

    @Override
    public EventHubImpl withPartitionCount(long count) {
        ((EventhubInner)this.inner()).withPartitionCount(count);
        return this;
    }

    @Override
    public EventHubImpl withRetentionPeriodInDays(long period) {
        ((EventhubInner)this.inner()).withMessageRetentionInDays(period);
        return this;
    }

    public EventHubImpl update() {
        this.captureSettings = new CaptureSettings((EventhubInner)this.inner());
        return (EventHubImpl)super.update();
    }

    public void beforeGroupCreateOrUpdate() {
        ((EventhubInner)this.inner()).withCaptureDescription(this.captureSettings.validateAndGetSettings());
    }

    public Observable<EventHub> createResourceAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).eventHubs().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), (EventhubInner)this.inner()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<EventhubInner> getInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).eventHubs().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public Observable<EventHubConsumerGroup> listConsumerGroupsAsync() {
        return this.manager.consumerGroups().listByEventHubAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public Observable<EventHubAuthorizationRule> listAuthorizationRulesAsync() {
        return this.manager.eventHubAuthorizationRules().listByEventHubAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedList<EventHubConsumerGroup> listConsumerGroups() {
        return this.manager.consumerGroups().listByEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedList<EventHubAuthorizationRule> listAuthorizationRules() {
        return this.manager.eventHubAuthorizationRules().listByEventHub(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.OneAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/eventhubs/%s", parentId, this.name());
    }

    private class CaptureSettings {
        private final CaptureDescription currentSettings;
        private CaptureDescription newSettings;

        CaptureSettings(EventhubInner eventhubInner) {
            this.currentSettings = eventhubInner.captureDescription();
        }

        public CaptureSettings withNewStorageAccountForCapturedData(final Creatable<StorageAccount> creatableStorageAccount, final String containerName) {
            this.ensureSettings().destination().withStorageAccountResourceId("temp-id");
            this.ensureSettings().destination().withBlobContainer(containerName);
            EventHubImpl.this.addDependency(new FunctionalTaskItem(){

                public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                    return creatableStorageAccount.createAsync().last().flatMap((Func1)new Func1<Indexable, Observable<Indexable>>(){

                        public Observable<Indexable> call(Indexable indexable) {
                            StorageAccount storageAccount = (StorageAccount)indexable;
                            CaptureSettings.this.ensureSettings().destination().withStorageAccountResourceId(storageAccount.id());
                            return CaptureSettings.this.createContainerIfNotExistsAsync(storageAccount, containerName).flatMap((Func1)new Func1<Boolean, Observable<Indexable>>(){

                                public Observable<Indexable> call(Boolean aBoolean) {
                                    return context.voidObservable();
                                }
                            });
                        }
                    });
                }
            });
            return this;
        }

        public CaptureSettings withExistingStorageAccountForCapturedData(final StorageAccount storageAccount, final String containerName) {
            this.ensureSettings().destination().withStorageAccountResourceId(storageAccount.id());
            this.ensureSettings().destination().withBlobContainer(containerName);
            EventHubImpl.this.addDependency(new FunctionalTaskItem(){

                public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                    return CaptureSettings.this.createContainerIfNotExistsAsync(storageAccount, containerName).flatMap((Func1)new Func1<Boolean, Observable<Indexable>>(){

                        public Observable<Indexable> call(Boolean aBoolean) {
                            return context.voidObservable();
                        }
                    });
                }
            });
            return this;
        }

        public CaptureSettings withExistingStorageAccountForCapturedData(final String storageAccountId, final String containerName) {
            this.ensureSettings().destination().withStorageAccountResourceId(storageAccountId);
            this.ensureSettings().destination().withBlobContainer(containerName);
            EventHubImpl.this.addDependency(new FunctionalTaskItem(){

                public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                    return EventHubImpl.this.storageManager.storageAccounts().getByIdAsync(storageAccountId).last().flatMap((Func1)new Func1<StorageAccount, Observable<Indexable>>(){

                        public Observable<Indexable> call(StorageAccount storageAccount) {
                            if (storageAccount == null) {
                                return Observable.error((Throwable)new Throwable(String.format("Storage account with id: %s not found (storing captured data)", storageAccountId)));
                            }
                            CaptureSettings.this.ensureSettings().destination().withStorageAccountResourceId(storageAccount.id());
                            return CaptureSettings.this.createContainerIfNotExistsAsync(storageAccount, containerName).flatMap((Func1)new Func1<Boolean, Observable<Indexable>>(){

                                public Observable<Indexable> call(Boolean aBoolean) {
                                    return context.voidObservable();
                                }
                            });
                        }
                    });
                }
            });
            return this;
        }

        public CaptureSettings withDataCaptureEnabled() {
            this.ensureSettings().withEnabled(true);
            return this;
        }

        public CaptureSettings withDataCaptureDisabled() {
            this.ensureSettings().withEnabled(false);
            return this;
        }

        public CaptureSettings withDataCaptureWindowSizeInSeconds(int sizeInSeconds) {
            this.ensureSettings().withIntervalInSeconds(sizeInSeconds);
            return this;
        }

        public CaptureSettings withDataCaptureWindowSizeInMB(int sizeInMB) {
            this.ensureSettings().withSizeLimitInBytes(sizeInMB * 1024 * 1024);
            return this;
        }

        public CaptureSettings withDataCaptureFileNameFormat(String format) {
            this.ensureSettings().destination().withArchiveNameFormat(format);
            return this;
        }

        public CaptureDescription validateAndGetSettings() {
            if (this.newSettings == null) {
                return this.currentSettings;
            }
            if (this.newSettings.destination() == null || this.newSettings.destination().storageAccountResourceId() == null || this.newSettings.destination().blobContainer() == null) {
                throw new IllegalStateException("Setting any of the capture properties requires capture destination [StorageAccount, DataLake] to be specified");
            }
            if (this.newSettings.destination().name() == null) {
                this.newSettings.destination().withName("EventHubArchive.AzureBlockBlob");
            }
            if (this.newSettings.encoding() == null) {
                this.newSettings.withEncoding(EncodingCaptureDescription.AVRO);
            }
            return this.newSettings;
        }

        private CaptureDescription ensureSettings() {
            if (this.newSettings != null) {
                return this.newSettings;
            }
            if (this.currentSettings == null) {
                this.newSettings = new CaptureDescription().withDestination(new Destination());
                return this.newSettings;
            }
            this.newSettings = this.cloneCurrentSettings();
            return this.newSettings;
        }

        private Observable<Boolean> createContainerIfNotExistsAsync(StorageAccount storageAccount, final String containerName) {
            return this.getCloudStorageAsync(storageAccount).flatMap((Func1)new Func1<CloudStorageAccount, Observable<Boolean>>(){

                public Observable<Boolean> call(final CloudStorageAccount cloudStorageAccount) {
                    return Observable.fromCallable((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            CloudBlobClient blobClient = cloudStorageAccount.createCloudBlobClient();
                            try {
                                return blobClient.getContainerReference(containerName).createIfNotExists();
                            }
                            catch (StorageException stgException) {
                                throw Exceptions.propagate((Throwable)stgException);
                            }
                            catch (URISyntaxException syntaxException) {
                                throw Exceptions.propagate((Throwable)syntaxException);
                            }
                        }
                    }).subscribeOn(SdkContext.getRxScheduler());
                }
            });
        }

        private Observable<CloudStorageAccount> getCloudStorageAsync(final StorageAccount storageAccount) {
            return storageAccount.getKeysAsync().flatMapIterable((Func1)new Func1<List<StorageAccountKey>, Iterable<StorageAccountKey>>(){

                public Iterable<StorageAccountKey> call(List<StorageAccountKey> storageAccountKeys) {
                    return storageAccountKeys;
                }
            }).last().map((Func1)new Func1<StorageAccountKey, CloudStorageAccount>(){

                public CloudStorageAccount call(StorageAccountKey storageAccountKey) {
                    try {
                        return CloudStorageAccount.parse((String)String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net", storageAccount.name(), storageAccountKey.value()));
                    }
                    catch (URISyntaxException syntaxException) {
                        throw Exceptions.propagate((Throwable)syntaxException);
                    }
                    catch (InvalidKeyException keyException) {
                        throw Exceptions.propagate((Throwable)keyException);
                    }
                }
            });
        }

        private CaptureDescription cloneCurrentSettings() {
            Objects.requireNonNull(this.currentSettings);
            CaptureDescription clone = new CaptureDescription();
            clone.withSizeLimitInBytes(this.currentSettings.sizeLimitInBytes());
            clone.withIntervalInSeconds(this.currentSettings.intervalInSeconds());
            clone.withEnabled(this.currentSettings.enabled());
            clone.withEncoding(this.currentSettings.encoding());
            if (this.currentSettings.destination() != null) {
                clone.withDestination(new Destination());
                clone.destination().withArchiveNameFormat(this.currentSettings.destination().archiveNameFormat());
                clone.destination().withBlobContainer(this.currentSettings.destination().blobContainer());
                clone.destination().withName(this.currentSettings.destination().name());
                clone.destination().withStorageAccountResourceId(this.currentSettings.destination().storageAccountResourceId());
            } else {
                clone.withDestination(new Destination());
            }
            return clone;
        }
    }
}

