/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.io.BaseEncoding;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.CertificateType;
import com.microsoft.azure.management.graphrbac.implementation.HasCredential;
import com.microsoft.azure.management.graphrbac.implementation.KeyCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.rest.RestClient;
import java.io.IOException;
import java.io.OutputStream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import rx.Observable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class CertificateCredentialImpl<T>
extends IndexableRefreshableWrapperImpl<CertificateCredential, KeyCredentialInner>
implements CertificateCredential,
CertificateCredential.Definition<T>,
CertificateCredential.UpdateDefinition<T> {
    private String name;
    private HasCredential<?> parent;
    private OutputStream authFile;
    private String privateKeyPath;
    private String privateKeyPassword;

    CertificateCredentialImpl(KeyCredentialInner keyCredential) {
        super((Object)keyCredential);
        this.name = keyCredential.customKeyIdentifier() != null && keyCredential.customKeyIdentifier().length > 0 ? new String(BaseEncoding.base64().decode((CharSequence)new String(keyCredential.customKeyIdentifier()))) : keyCredential.keyId();
    }

    CertificateCredentialImpl(String name, HasCredential<?> parent) {
        super((Object)new KeyCredentialInner().withUsage("Verify").withCustomKeyIdentifier(BaseEncoding.base64().encode(name.getBytes()).getBytes()).withStartDate(DateTime.now()).withEndDate(DateTime.now().plusYears(1)));
        this.name = name;
        this.parent = parent;
    }

    public Observable<CertificateCredential> refreshAsync() {
        throw new UnsupportedOperationException("Cannot refresh credentials.");
    }

    protected Observable<KeyCredentialInner> getInnerAsync() {
        throw new UnsupportedOperationException("Cannot refresh credentials.");
    }

    public String id() {
        return ((KeyCredentialInner)this.inner()).keyId();
    }

    @Override
    public DateTime startDate() {
        return ((KeyCredentialInner)this.inner()).startDate();
    }

    @Override
    public DateTime endDate() {
        return ((KeyCredentialInner)this.inner()).endDate();
    }

    @Override
    public String value() {
        return ((KeyCredentialInner)this.inner()).value();
    }

    public T attach() {
        this.parent.withCertificateCredential(this);
        return (T)this.parent;
    }

    @Override
    public CertificateCredentialImpl<T> withStartDate(DateTime startDate) {
        DateTime original = this.startDate();
        ((KeyCredentialInner)this.inner()).withStartDate(startDate);
        this.withDuration(Duration.millis((long)(this.endDate().getMillis() - original.getMillis())));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withDuration(Duration duration) {
        ((KeyCredentialInner)this.inner()).withEndDate(this.startDate().plus(duration.getMillis()));
        return this;
    }

    public String name() {
        return this.name;
    }

    @Override
    public CertificateCredentialImpl<T> withAsymmetricX509Certificate() {
        ((KeyCredentialInner)this.inner()).withType(CertificateType.ASYMMETRIC_X509_CERT.toString());
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withSymmetricEncryption() {
        ((KeyCredentialInner)this.inner()).withType(CertificateType.SYMMETRIC.toString());
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPublicKey(byte[] certificate) {
        ((KeyCredentialInner)this.inner()).withValue(BaseEncoding.base64().encode(certificate));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withSecretKey(byte[] secret) {
        ((KeyCredentialInner)this.inner()).withValue(BaseEncoding.base64().encode(secret));
        return this;
    }

    void exportAuthFile(ServicePrincipalImpl servicePrincipal) {
        if (this.authFile == null) {
            return;
        }
        RestClient restClient = servicePrincipal.manager().roleInner().restClient();
        AzureEnvironment environment = null;
        if (restClient.credentials() instanceof AzureTokenCredentials) {
            environment = ((AzureTokenCredentials)restClient.credentials()).environment();
        } else {
            String baseUrl = restClient.retrofit().baseUrl().toString();
            for (AzureEnvironment env : AzureEnvironment.knownEnvironments()) {
                if (!env.resourceManagerEndpoint().toLowerCase().contains(baseUrl.toLowerCase())) continue;
                environment = env;
                break;
            }
            if (environment == null) {
                throw new IllegalArgumentException("Unknown resource manager endpoint " + baseUrl);
            }
        }
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  ").append(String.format("\"clientId\": \"%s\",", servicePrincipal.applicationId())).append("\n");
        builder.append("  ").append(String.format("\"clientCertificate\": \"%s\",", this.privateKeyPath.replace("\\", "\\\\"))).append("\n");
        builder.append("  ").append(String.format("\"clientCertificatePassword\": \"%s\",", this.privateKeyPassword)).append("\n");
        builder.append("  ").append(String.format("\"tenantId\": \"%s\",", servicePrincipal.manager().tenantId())).append("\n");
        builder.append("  ").append(String.format("\"subscriptionId\": \"%s\",", servicePrincipal.assignedSubscription)).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryEndpointUrl\": \"%s\",", environment.activeDirectoryEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"resourceManagerEndpointUrl\": \"%s\",", environment.resourceManagerEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryGraphResourceId\": \"%s\",", environment.graphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"managementEndpointUrl\": \"%s\"", environment.managementEndpoint())).append("\n");
        builder.append("}");
        try {
            this.authFile.write(builder.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CertificateCredentialImpl<T> withAuthFileToExport(OutputStream outputStream) {
        this.authFile = outputStream;
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPrivateKeyFile(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }
}

