/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.resources.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in PolicySetDefinitions.
 */
public class PolicySetDefinitionsInner {
    /** The Retrofit service to perform REST calls. */
    private PolicySetDefinitionsService service;
    /** The service client containing this operation class. */
    private PolicyClientImpl client;

    /**
     * Initializes an instance of PolicySetDefinitionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PolicySetDefinitionsInner(Retrofit retrofit, PolicyClientImpl client) {
        this.service = retrofit.create(PolicySetDefinitionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for PolicySetDefinitions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PolicySetDefinitionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("policySetDefinitionName") String policySetDefinitionName, @Path("subscriptionId") String subscriptionId, @Body PolicySetDefinitionInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("policySetDefinitionName") String policySetDefinitionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions get" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        Observable<Response<ResponseBody>> get(@Path("policySetDefinitionName") String policySetDefinitionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions getBuiltIn" })
        @GET("providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        Observable<Response<ResponseBody>> getBuiltIn(@Path("policySetDefinitionName") String policySetDefinitionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listBuiltIn" })
        @GET("providers/Microsoft.Authorization/policySetDefinitions")
        Observable<Response<ResponseBody>> listBuiltIn(@Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions createOrUpdateAtManagementGroup" })
        @PUT("providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        Observable<Response<ResponseBody>> createOrUpdateAtManagementGroup(@Path("policySetDefinitionName") String policySetDefinitionName, @Path("managementGroupId") String managementGroupId, @Body PolicySetDefinitionInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions deleteAtManagementGroup" })
        @HTTP(path = "providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteAtManagementGroup(@Path("policySetDefinitionName") String policySetDefinitionName, @Path("managementGroupId") String managementGroupId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions getAtManagementGroup" })
        @GET("providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        Observable<Response<ResponseBody>> getAtManagementGroup(@Path("policySetDefinitionName") String policySetDefinitionName, @Path("managementGroupId") String managementGroupId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listByManagementGroup" })
        @GET("providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions")
        Observable<Response<ResponseBody>> listByManagementGroup(@Path("managementGroupId") String managementGroupId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listBuiltInNext" })
        @GET
        Observable<Response<ResponseBody>> listBuiltInNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.PolicySetDefinitions listByManagementGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByManagementGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PolicySetDefinitionInner object if successful.
     */
    public PolicySetDefinitionInner createOrUpdate(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return createOrUpdateWithServiceResponseAsync(policySetDefinitionName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters, final ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(policySetDefinitionName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return createOrUpdateWithServiceResponseAsync(policySetDefinitionName, parameters).map(new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>() {
            @Override
            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<ServiceResponse<PolicySetDefinitionInner>> createOrUpdateWithServiceResponseAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-06-01-preview";
        return service.createOrUpdate(policySetDefinitionName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PolicySetDefinitionInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PolicySetDefinitionInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PolicySetDefinitionInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .register(201, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String policySetDefinitionName) {
        deleteWithServiceResponseAsync(policySetDefinitionName).toBlocking().single().body();
    }

    /**
     * Deletes a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String policySetDefinitionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(policySetDefinitionName), serviceCallback);
    }

    /**
     * Deletes a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String policySetDefinitionName) {
        return deleteWithServiceResponseAsync(policySetDefinitionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String policySetDefinitionName) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.delete(policySetDefinitionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PolicySetDefinitionInner object if successful.
     */
    public PolicySetDefinitionInner get(String policySetDefinitionName) {
        return getWithServiceResponseAsync(policySetDefinitionName).toBlocking().single().body();
    }

    /**
     * Gets the policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PolicySetDefinitionInner> getAsync(String policySetDefinitionName, final ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(policySetDefinitionName), serviceCallback);
    }

    /**
     * Gets the policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<PolicySetDefinitionInner> getAsync(String policySetDefinitionName) {
        return getWithServiceResponseAsync(policySetDefinitionName).map(new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>() {
            @Override
            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<ServiceResponse<PolicySetDefinitionInner>> getWithServiceResponseAsync(String policySetDefinitionName) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.get(policySetDefinitionName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PolicySetDefinitionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PolicySetDefinitionInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PolicySetDefinitionInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the built in policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PolicySetDefinitionInner object if successful.
     */
    public PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName) {
        return getBuiltInWithServiceResponseAsync(policySetDefinitionName).toBlocking().single().body();
    }

    /**
     * Gets the built in policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName, final ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getBuiltInWithServiceResponseAsync(policySetDefinitionName), serviceCallback);
    }

    /**
     * Gets the built in policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName) {
        return getBuiltInWithServiceResponseAsync(policySetDefinitionName).map(new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>() {
            @Override
            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the built in policy set definition.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<ServiceResponse<PolicySetDefinitionInner>> getBuiltInWithServiceResponseAsync(String policySetDefinitionName) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.getBuiltIn(policySetDefinitionName, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PolicySetDefinitionInner> clientResponse = getBuiltInDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PolicySetDefinitionInner> getBuiltInDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PolicySetDefinitionInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object if successful.
     */
    public PagedList<PolicySetDefinitionInner> list() {
        ServiceResponse<Page<PolicySetDefinitionInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>(response.body()) {
            @Override
            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PolicySetDefinitionInner>> listAsync(final ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<Page<PolicySetDefinitionInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>() {
                @Override
                public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PolicySetDefinitionInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PolicySetDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PolicySetDefinitionInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object if successful.
     */
    public PagedList<PolicySetDefinitionInner> listBuiltIn() {
        ServiceResponse<Page<PolicySetDefinitionInner>> response = listBuiltInSinglePageAsync().toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>(response.body()) {
            @Override
            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PolicySetDefinitionInner>> listBuiltInAsync(final ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBuiltInSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                    return listBuiltInNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<Page<PolicySetDefinitionInner>> listBuiltInAsync() {
        return listBuiltInWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>() {
                @Override
                public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInWithServiceResponseAsync() {
        return listBuiltInSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBuiltInNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInSinglePageAsync() {
        final String apiVersion = "2017-06-01-preview";
        return service.listBuiltIn(apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PolicySetDefinitionInner>> result = listBuiltInDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PolicySetDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listBuiltInDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PolicySetDefinitionInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates or updates a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PolicySetDefinitionInner object if successful.
     */
    public PolicySetDefinitionInner createOrUpdateAtManagementGroup(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return createOrUpdateAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters, final ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId, parameters), serviceCallback);
    }

    /**
     * Creates or updates a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return createOrUpdateAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId, parameters).map(new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>() {
            @Override
            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<ServiceResponse<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithServiceResponseAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-06-01-preview";
        return service.createOrUpdateAtManagementGroup(policySetDefinitionName, managementGroupId, parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PolicySetDefinitionInner> clientResponse = createOrUpdateAtManagementGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PolicySetDefinitionInner> createOrUpdateAtManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PolicySetDefinitionInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .register(201, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        deleteAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).toBlocking().single().body();
    }

    /**
     * Deletes a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId), serviceCallback);
    }

    /**
     * Deletes a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return deleteAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteAtManagementGroupWithServiceResponseAsync(String policySetDefinitionName, String managementGroupId) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.deleteAtManagementGroup(policySetDefinitionName, managementGroupId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteAtManagementGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteAtManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PolicySetDefinitionInner object if successful.
     */
    public PolicySetDefinitionInner getAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        return getAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).toBlocking().single().body();
    }

    /**
     * Gets the policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PolicySetDefinitionInner> getAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, final ServiceCallback<PolicySetDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId), serviceCallback);
    }

    /**
     * Gets the policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<PolicySetDefinitionInner> getAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return getAtManagementGroupWithServiceResponseAsync(policySetDefinitionName, managementGroupId).map(new Func1<ServiceResponse<PolicySetDefinitionInner>, PolicySetDefinitionInner>() {
            @Override
            public PolicySetDefinitionInner call(ServiceResponse<PolicySetDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the policy set definition at management group level.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PolicySetDefinitionInner object
     */
    public Observable<ServiceResponse<PolicySetDefinitionInner>> getAtManagementGroupWithServiceResponseAsync(String policySetDefinitionName, String managementGroupId) {
        if (policySetDefinitionName == null) {
            throw new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null.");
        }
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.getAtManagementGroup(policySetDefinitionName, managementGroupId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PolicySetDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<PolicySetDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PolicySetDefinitionInner> clientResponse = getAtManagementGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PolicySetDefinitionInner> getAtManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PolicySetDefinitionInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PolicySetDefinitionInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object if successful.
     */
    public PagedList<PolicySetDefinitionInner> listByManagementGroup(final String managementGroupId) {
        ServiceResponse<Page<PolicySetDefinitionInner>> response = listByManagementGroupSinglePageAsync(managementGroupId).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>(response.body()) {
            @Override
            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PolicySetDefinitionInner>> listByManagementGroupAsync(final String managementGroupId, final ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByManagementGroupSinglePageAsync(managementGroupId),
            new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                    return listByManagementGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<Page<PolicySetDefinitionInner>> listByManagementGroupAsync(final String managementGroupId) {
        return listByManagementGroupWithServiceResponseAsync(managementGroupId)
            .map(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>() {
                @Override
                public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupWithServiceResponseAsync(final String managementGroupId) {
        return listByManagementGroupSinglePageAsync(managementGroupId)
            .concatMap(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByManagementGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
    ServiceResponse<PageImpl<PolicySetDefinitionInner>> * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupSinglePageAsync(final String managementGroupId) {
        if (managementGroupId == null) {
            throw new IllegalArgumentException("Parameter managementGroupId is required and cannot be null.");
        }
        final String apiVersion = "2017-06-01-preview";
        return service.listByManagementGroup(managementGroupId, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PolicySetDefinitionInner>> result = listByManagementGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PolicySetDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listByManagementGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PolicySetDefinitionInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object if successful.
     */
    public PagedList<PolicySetDefinitionInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<PolicySetDefinitionInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>(response.body()) {
            @Override
            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PolicySetDefinitionInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<PolicySetDefinitionInner>> serviceFuture, final ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<Page<PolicySetDefinitionInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>() {
                @Override
                public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription.
     *
    ServiceResponse<PageImpl<PolicySetDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PolicySetDefinitionInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PolicySetDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PolicySetDefinitionInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object if successful.
     */
    public PagedList<PolicySetDefinitionInner> listBuiltInNext(final String nextPageLink) {
        ServiceResponse<Page<PolicySetDefinitionInner>> response = listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>(response.body()) {
            @Override
            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return listBuiltInNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PolicySetDefinitionInner>> listBuiltInNextAsync(final String nextPageLink, final ServiceFuture<List<PolicySetDefinitionInner>> serviceFuture, final ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBuiltInNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                    return listBuiltInNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<Page<PolicySetDefinitionInner>> listBuiltInNextAsync(final String nextPageLink) {
        return listBuiltInNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>() {
                @Override
                public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the built in policy set definitions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInNextWithServiceResponseAsync(final String nextPageLink) {
        return listBuiltInNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBuiltInNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the built in policy set definitions.
     *
    ServiceResponse<PageImpl<PolicySetDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listBuiltInNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBuiltInNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PolicySetDefinitionInner>> result = listBuiltInNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PolicySetDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listBuiltInNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PolicySetDefinitionInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object if successful.
     */
    public PagedList<PolicySetDefinitionInner> listByManagementGroupNext(final String nextPageLink) {
        ServiceResponse<Page<PolicySetDefinitionInner>> response = listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PolicySetDefinitionInner>(response.body()) {
            @Override
            public Page<PolicySetDefinitionInner> nextPage(String nextPageLink) {
                return listByManagementGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PolicySetDefinitionInner>> listByManagementGroupNextAsync(final String nextPageLink, final ServiceFuture<List<PolicySetDefinitionInner>> serviceFuture, final ListOperationCallback<PolicySetDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByManagementGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(String nextPageLink) {
                    return listByManagementGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<Page<PolicySetDefinitionInner>> listByManagementGroupNextAsync(final String nextPageLink) {
        return listByManagementGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Page<PolicySetDefinitionInner>>() {
                @Override
                public Page<PolicySetDefinitionInner> call(ServiceResponse<Page<PolicySetDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PolicySetDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByManagementGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PolicySetDefinitionInner>>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(ServiceResponse<Page<PolicySetDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByManagementGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the policy set definitions for a subscription at management group.
     *
    ServiceResponse<PageImpl<PolicySetDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PolicySetDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> listByManagementGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByManagementGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PolicySetDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PolicySetDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PolicySetDefinitionInner>> result = listByManagementGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PolicySetDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PolicySetDefinitionInner>> listByManagementGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PolicySetDefinitionInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PolicySetDefinitionInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
