/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.google.common.primitives.Ints;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.rest.RestClient;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Url;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class Utils {
    public static boolean toPrimitiveBoolean(Boolean value) {
        if (value == null) {
            return false;
        }
        return value;
    }

    public static int toPrimitiveInt(Integer value) {
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static int toPrimitiveInt(Long value) {
        if (value == null) {
            return 0;
        }
        return Ints.checkedCast((long)value);
    }

    public static long toPrimitiveLong(Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public static String createOdataFilterForTags(String tagName, String tagValue) {
        if (tagName == null) {
            return null;
        }
        if (tagValue == null) {
            return String.format("tagname eq '%s'", tagName);
        }
        return String.format("tagname eq '%s' and tagvalue eq '%s'", tagName, tagValue);
    }

    public static <U extends Indexable> Observable<U> rootResource(Observable<Indexable> stream) {
        return stream.last().map(new Func1<Indexable, U>(){

            public U call(Indexable indexable) {
                return indexable;
            }
        });
    }

    public static Observable<byte[]> downloadFileAsync(String url, Retrofit retrofit) {
        FileService service = (FileService)retrofit.create(FileService.class);
        Observable<ResponseBody> response = service.download(url);
        return response.map((Func1)new Func1<ResponseBody, byte[]>(){

            public byte[] call(ResponseBody responseBody) {
                try {
                    return responseBody.bytes();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    public static <OutT, InT> PagedList<OutT> toPagedList(List<InT> list, final Func1<InT, OutT> mapper) {
        PageImpl<InT> page = new PageImpl<InT>();
        page.setItems(list);
        page.setNextPageLink(null);
        PagedList pagedList = new PagedList<InT>(page){

            public Page<InT> nextPage(String nextPageLink) {
                return null;
            }
        };
        PagedListConverter converter = new PagedListConverter<InT, OutT>(){

            @Override
            public Observable<OutT> typeConvertAsync(InT inner) {
                return Observable.just((Object)mapper.call(inner));
            }
        };
        return converter.convert(pagedList);
    }

    public static void addToListIfNotExists(List<String> list, String value) {
        boolean found = false;
        for (String item : list) {
            if (!item.equalsIgnoreCase(value)) continue;
            found = true;
            break;
        }
        if (!found) {
            list.add(value);
        }
    }

    public static void removeFromList(List<String> list, String value) {
        int foundIndex = -1;
        int i = 0;
        for (String id : list) {
            if (id.equalsIgnoreCase(value)) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            list.remove(foundIndex);
        }
    }

    public static AzureEnvironment extractAzureEnvironment(RestClient restClient) {
        AzureEnvironment environment = null;
        if (restClient.credentials() instanceof AzureTokenCredentials) {
            environment = ((AzureTokenCredentials)restClient.credentials()).environment();
        } else {
            String baseUrl = restClient.retrofit().baseUrl().toString();
            for (AzureEnvironment env : AzureEnvironment.knownEnvironments()) {
                if (!env.resourceManagerEndpoint().toLowerCase().contains(baseUrl.toLowerCase())) continue;
                environment = env;
                break;
            }
            if (environment == null) {
                throw new IllegalArgumentException("Unknown resource manager endpoint " + baseUrl);
            }
        }
        return environment;
    }

    public static String resourceGroupId(String id) {
        ResourceId resourceId = ResourceId.fromString(id);
        return String.format("/subscriptions/%s/resourceGroups/%s", resourceId.subscriptionId(), resourceId.resourceGroupName());
    }

    private Utils() {
    }

    private static interface FileService {
        @GET
        public Observable<ResponseBody> download(@Url String var1);
    }
}

