/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsBatchDeletion;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsDeletingByResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingById;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsListingByResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsListing;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.RXMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import rx.Completable;
import rx.Observable;

public abstract class TopLevelModifiableResourcesImpl<T extends GroupableResource<ManagerT, InnerT>, ImplT extends T, InnerT extends Resource, InnerCollectionT extends InnerSupportsListing<InnerT> & InnerSupportsGet<InnerT>, ManagerT extends ManagerBase>
extends GroupableResourcesImpl<T, ImplT, InnerT, InnerCollectionT, ManagerT>
implements SupportsGettingById<T>,
SupportsGettingByResourceGroup<T>,
SupportsDeletingByResourceGroup,
HasManager<ManagerT>,
HasInner<InnerCollectionT>,
SupportsListing<T>,
SupportsListingByResourceGroup<T>,
SupportsBatchDeletion {
    protected TopLevelModifiableResourcesImpl(InnerCollectionT innerCollection, ManagerT manager) {
        super(innerCollection, manager);
    }

    @Override
    protected final Observable<InnerT> getInnerAsync(String resourceGroupName, String name) {
        return ((InnerSupportsGet)((Object)((InnerSupportsListing)this.inner()))).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((InnerSupportsDelete)((Object)((InnerSupportsListing)this.inner()))).deleteAsync(resourceGroupName, name).toCompletable();
    }

    @Override
    public Observable<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public Observable<String> deleteByIdsAsync(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Observable.empty();
        }
        ArrayList<Observable<String>> observables = new ArrayList<Observable<String>>();
        for (String id : ids) {
            String resourceGroupName = ResourceUtils.groupFromResourceId(id);
            String name = ResourceUtils.nameFromResourceId(id);
            Observable<String> o = RXMapper.map(((InnerSupportsDelete)((Object)((InnerSupportsListing)this.inner()))).deleteAsync(resourceGroupName, name), id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }

    @Override
    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).toBlocking().last();
        }
    }

    @Override
    public Observable<T> listAsync() {
        return this.wrapPageAsync(((InnerSupportsListing)this.inner()).listAsync());
    }

    @Override
    public Observable<T> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((InnerSupportsListing)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedList<T> list() {
        return this.wrapList(((InnerSupportsListing)this.inner()).list());
    }

    @Override
    public PagedList<T> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(((InnerSupportsListing)this.inner()).listByResourceGroup(resourceGroupName));
    }
}

