/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.Policykey;
import com.microsoft.azure.management.servicebus.QueueAuthorizationRule;
import com.microsoft.azure.management.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.servicebus.implementation.QueueImpl;
import com.microsoft.azure.management.servicebus.implementation.ResourceListKeysInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class QueueAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<QueueAuthorizationRule, QueueImpl, SharedAccessAuthorizationRuleInner, QueueAuthorizationRuleImpl, ServiceBusManager>
implements QueueAuthorizationRule,
QueueAuthorizationRule.Definition,
QueueAuthorizationRule.Update {
    private final String namespaceName;
    private final Region region;

    QueueAuthorizationRuleImpl(String resourceGroupName, String namespaceName, String queueName, String name, Region region, SharedAccessAuthorizationRuleInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.namespaceName = namespaceName;
        this.region = region;
        this.withExistingParentResource(resourceGroupName, queueName);
        if (inner.location() == null) {
            inner.withLocation(this.region.toString());
        }
    }

    @Override
    public String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public String queueName() {
        return this.parentName;
    }

    protected Observable<SharedAccessAuthorizationRuleInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).queues().getAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name());
    }

    protected Observable<QueueAuthorizationRule> createChildResourceAsync() {
        final QueueAuthorizationRuleImpl self = this;
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).queues().createOrUpdateAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name(), ((SharedAccessAuthorizationRuleInner)((Object)this.inner())).rights()).map((Func1)new Func1<SharedAccessAuthorizationRuleInner, QueueAuthorizationRule>(){

            public QueueAuthorizationRule call(SharedAccessAuthorizationRuleInner inner) {
                QueueAuthorizationRuleImpl.this.setInner((Object)inner);
                return self;
            }
        });
    }

    @Override
    protected Observable<ResourceListKeysInner> getKeysInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).queues().listKeysAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name());
    }

    @Override
    protected Observable<ResourceListKeysInner> regenerateKeysInnerAsync(Policykey policykey) {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).queues().regenerateKeysAsync(this.resourceGroupName(), this.namespaceName(), this.queueName(), this.name(), policykey);
    }
}

