/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.JobCredentialInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobCredentialsInner {
    private JobCredentialsService service;
    private SqlManagementClientImpl client;

    public JobCredentialsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobCredentialsService)retrofit.create(JobCredentialsService.class);
        this.client = client;
    }

    public PagedList<JobCredentialInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName) {
        ServiceResponse response = (ServiceResponse)this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single();
        return new PagedList<JobCredentialInner>((Page)response.body()){

            public Page<JobCredentialInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobCredentialsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobCredentialInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, ListOperationCallback<JobCredentialInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobCredentialInner>>>>(){

            public Observable<ServiceResponse<Page<JobCredentialInner>>> call(String nextPageLink) {
                return JobCredentialsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobCredentialInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<Page<JobCredentialInner>>, Page<JobCredentialInner>>(){

            public Page<JobCredentialInner> call(ServiceResponse<Page<JobCredentialInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).concatMap((Func1)new Func1<ServiceResponse<Page<JobCredentialInner>>, Observable<ServiceResponse<Page<JobCredentialInner>>>>(){

            public Observable<ServiceResponse<Page<JobCredentialInner>>> call(ServiceResponse<Page<JobCredentialInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobCredentialsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobCredentialInner>>>>(){

            public Observable<ServiceResponse<Page<JobCredentialInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobCredentialsInner.this.listByAgentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobCredentialInner>> listByAgentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobCredentialInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobCredentialInner get(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        return (JobCredentialInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).toBlocking().single()).body();
    }

    public ServiceFuture<JobCredentialInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, ServiceCallback<JobCredentialInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName), serviceCallback);
    }

    public Observable<JobCredentialInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).map((Func1)new Func1<ServiceResponse<JobCredentialInner>, JobCredentialInner>(){

            public JobCredentialInner call(ServiceResponse<JobCredentialInner> response) {
                return (JobCredentialInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<JobCredentialInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, credentialName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobCredentialInner>>>(){

            public Observable<ServiceResponse<JobCredentialInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobCredentialsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobCredentialInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobCredentialInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobCredentialInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters) {
        return (JobCredentialInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<JobCredentialInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters, ServiceCallback<JobCredentialInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName, parameters), serviceCallback);
    }

    public Observable<JobCredentialInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName, parameters).map((Func1)new Func1<ServiceResponse<JobCredentialInner>, JobCredentialInner>(){

            public JobCredentialInner call(ServiceResponse<JobCredentialInner> response) {
                return (JobCredentialInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<JobCredentialInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, JobCredentialInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, jobAgentName, credentialName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobCredentialInner>>>(){

            public Observable<ServiceResponse<JobCredentialInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobCredentialsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobCredentialInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobCredentialInner>(){}.getType()).register(201, new TypeToken<JobCredentialInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, credentialName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String credentialName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (credentialName == null) {
            throw new IllegalArgumentException("Parameter credentialName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, jobAgentName, credentialName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobCredentialsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobCredentialInner> listByAgentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobCredentialInner>((Page)response.body()){

            public Page<JobCredentialInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobCredentialsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobCredentialInner>> listByAgentNextAsync(String nextPageLink, ServiceFuture<List<JobCredentialInner>> serviceFuture, ListOperationCallback<JobCredentialInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobCredentialInner>>>>(){

            public Observable<ServiceResponse<Page<JobCredentialInner>>> call(String nextPageLink) {
                return JobCredentialsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobCredentialInner>> listByAgentNextAsync(String nextPageLink) {
        return this.listByAgentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobCredentialInner>>, Page<JobCredentialInner>>(){

            public Page<JobCredentialInner> call(ServiceResponse<Page<JobCredentialInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAgentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobCredentialInner>>, Observable<ServiceResponse<Page<JobCredentialInner>>>>(){

            public Observable<ServiceResponse<Page<JobCredentialInner>>> call(ServiceResponse<Page<JobCredentialInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobCredentialsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobCredentialInner>>> listByAgentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAgentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobCredentialInner>>>>(){

            public Observable<ServiceResponse<Page<JobCredentialInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobCredentialsInner.this.listByAgentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobCredentialInner>> listByAgentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobCredentialInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobCredentialsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials listByAgent"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials")
        public Observable<Response<ResponseBody>> listByAgent(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="credentialName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="credentialName") String var4, @Path(value="subscriptionId") String var5, @Body JobCredentialInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="credentialName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobCredentials listByAgentNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAgentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

