/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.ServerKeyType;
import com.microsoft.azure.management.sql.SqlEncryptionProtector;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.EncryptionProtectorInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlEncryptionProtectorImpl
extends ExternalChildResourceImpl<SqlEncryptionProtector, EncryptionProtectorInner, SqlServerImpl, SqlServer>
implements SqlEncryptionProtector,
SqlEncryptionProtector.Update {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String serverKeyName;

    SqlEncryptionProtectorImpl(SqlServerImpl parent, EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlEncryptionProtectorImpl(String resourceGroupName, String sqlServerName, EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlEncryptionProtectorImpl(EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            if (innerObject.name() != null) {
                this.serverKeyName = innerObject.name();
            }
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String id() {
        return ((EncryptionProtectorInner)this.inner()).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.serverKeyName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((EncryptionProtectorInner)this.inner()).id());
    }

    @Override
    public String kind() {
        return ((EncryptionProtectorInner)this.inner()).kind();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((EncryptionProtectorInner)this.inner()).location());
    }

    @Override
    public String serverKeyName() {
        return ((EncryptionProtectorInner)this.inner()).serverKeyName();
    }

    @Override
    public ServerKeyType serverKeyType() {
        return ((EncryptionProtectorInner)this.inner()).serverKeyType();
    }

    @Override
    public String uri() {
        return ((EncryptionProtectorInner)this.inner()).uri();
    }

    @Override
    public String thumbprint() {
        return ((EncryptionProtectorInner)this.inner()).thumbprint();
    }

    @Override
    public SqlEncryptionProtectorImpl withAzureKeyVaultServerKey(String serverKeyName) {
        ((EncryptionProtectorInner)this.inner()).withServerKeyName(serverKeyName);
        ((EncryptionProtectorInner)this.inner()).withServerKeyType(ServerKeyType.AZURE_KEY_VAULT);
        return this;
    }

    @Override
    public SqlEncryptionProtectorImpl withServiceManagedServerKey() {
        ((EncryptionProtectorInner)this.inner()).withServerKeyName("ServiceManaged");
        ((EncryptionProtectorInner)this.inner()).withServerKeyType(ServerKeyType.SERVICE_MANAGED);
        return this;
    }

    public Observable<SqlEncryptionProtector> createResourceAsync() {
        final SqlEncryptionProtectorImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).encryptionProtectors().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, (EncryptionProtectorInner)this.inner()).map((Func1)new Func1<EncryptionProtectorInner, SqlEncryptionProtector>(){

            public SqlEncryptionProtector call(EncryptionProtectorInner encryptionProtectorInner) {
                self.setInner(encryptionProtectorInner);
                return self;
            }
        });
    }

    public SqlEncryptionProtectorImpl update() {
        return this;
    }

    public Observable<SqlEncryptionProtector> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        throw new NotImplementedException("Operation not supported");
    }

    protected Observable<EncryptionProtectorInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).encryptionProtectors().getAsync(this.resourceGroupName, this.sqlServerName);
    }
}

