/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.jms;

import com.microsoft.azure.servicebus.jms.ServiceBusJmsSession;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

class ServiceBusJmsConnection
implements Connection {
    private final Connection innerConnection;

    ServiceBusJmsConnection(Connection innerConnection) {
        this.innerConnection = innerConnection;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session innerSession = this.innerConnection.createSession(transacted, acknowledgeMode);
        return new ServiceBusJmsSession(innerSession);
    }

    public Session createSession(int sessionMode) throws JMSException {
        Session innerSession = this.innerConnection.createSession(sessionMode);
        return new ServiceBusJmsSession(innerSession);
    }

    public Session createSession() throws JMSException {
        Session innerSession = this.innerConnection.createSession();
        return new ServiceBusJmsSession(innerSession);
    }

    public String getClientID() throws JMSException {
        return this.innerConnection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.innerConnection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.innerConnection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.innerConnection.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.innerConnection.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.innerConnection.start();
    }

    public void stop() throws JMSException {
        this.innerConnection.stop();
    }

    public void close() throws JMSException {
        this.innerConnection.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.innerConnection.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.innerConnection.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.innerConnection.createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.innerConnection.createSharedConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }
}

