/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.RetryExponential;
import com.microsoft.azure.servicebus.primitives.ServerBusyException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RetryPolicy {
    private static final RetryPolicy NO_RETRY = new RetryExponential(Duration.ofSeconds(0L), Duration.ofSeconds(0L), 0, "NoRetry");
    private final String name;
    private ConcurrentHashMap<String, Integer> retryCounts;

    protected RetryPolicy(String name) {
        this.name = name;
        this.retryCounts = new ConcurrentHashMap();
    }

    public void incrementRetryCount(String clientId) {
        Integer retryCount = this.retryCounts.get(clientId);
        this.retryCounts.put(clientId, retryCount == null ? 1 : retryCount + 1);
    }

    public void resetRetryCount(String clientId) {
        this.retryCounts.computeIfPresent(clientId, (k, v) -> 0);
    }

    public static boolean isRetryableException(Exception exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception cannot be null.");
        }
        if (exception instanceof ServiceBusException) {
            return ((ServiceBusException)exception).getIsTransient();
        }
        return false;
    }

    public static RetryPolicy getDefault() {
        return new RetryExponential(ClientConstants.DEFAULT_RERTRY_MIN_BACKOFF, ClientConstants.DEFAULT_RERTRY_MAX_BACKOFF, 10, "Default");
    }

    public static RetryPolicy getNoRetry() {
        return NO_RETRY;
    }

    protected int getRetryCount(String clientId) {
        Integer retryCount = this.retryCounts.get(clientId);
        return retryCount == null ? 0 : retryCount;
    }

    public Duration getNextRetryInterval(String clientId, Exception lastException, Duration remainingTime) {
        if (!RetryPolicy.isRetryableException(lastException)) {
            return null;
        }
        int baseWaitTime = 0;
        if (lastException != null && (lastException instanceof ServerBusyException || lastException.getCause() != null && lastException.getCause() instanceof ServerBusyException)) {
            baseWaitTime += 4;
        }
        return this.onGetNextRetryInterval(clientId, lastException, remainingTime, baseWaitTime);
    }

    protected abstract Duration onGetNextRetryInterval(String var1, Exception var2, Duration var3, int var4);

    public String toString() {
        return this.name;
    }
}

