/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.security;

import com.microsoft.azure.servicebus.security.AzureActiveDirectoryTokenProvider;
import com.microsoft.azure.servicebus.security.ManagedIdentityTokenProvider;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SharedAccessSignatureTokenProvider;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

public abstract class TokenProvider {
    public abstract CompletableFuture<SecurityToken> getSecurityTokenAsync(String var1);

    public static TokenProvider createSharedAccessSignatureTokenProvider(String sasKeyName, String sasKey) {
        return new SharedAccessSignatureTokenProvider(sasKeyName, sasKey, 1200);
    }

    public static TokenProvider createSharedAccessSignatureTokenProvider(String sasToken, Instant sasTokenValidUntil) {
        return new SharedAccessSignatureTokenProvider(sasToken, sasTokenValidUntil);
    }

    public static TokenProvider createAzureActiveDirectoryTokenProvider(AzureActiveDirectoryTokenProvider.AuthenticationCallback callback, String authority, Object callbackState) {
        if (callback == null) {
            throw new IllegalArgumentException("The callback provided cannot be null.");
        }
        if (authority == null) {
            throw new IllegalArgumentException("The authority provided cannot be null.");
        }
        return new AzureActiveDirectoryTokenProvider(callback, authority, callbackState);
    }

    public static TokenProvider createManagedIdentityTokenProvider() {
        return new ManagedIdentityTokenProvider();
    }
}

