/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.AuthParametersHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.sun.jna.WString;
import java.net.URI;
import java.util.Map;

public class AuthParameters
implements AutoCloseable {
    private AuthParametersHandle handle;

    private AuthParameters(AuthParametersBuilder builder) {
        this.handle = builder.handle;
    }

    public AuthParametersHandle getHandle() {
        return this.handle;
    }

    @Deprecated
    public void setUsernamePassword(String username, String password) {
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetAdditionalParameter(this.handle.value(), new WString("MSALRuntime_Username"), new WString(username)));
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetAdditionalParameter(this.handle.value(), new WString("MSALRuntime_Password"), new WString(password)));
    }

    @Override
    public void close() {
        if (this.handle != null) {
            this.handle.close();
            this.handle = null;
        }
    }

    public static class AuthParametersBuilder {
        private AuthParametersHandle handle = new AuthParametersHandle();

        public AuthParametersBuilder(String clientId, String authority, String scopes) {
            MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_CreateAuthParameters(new WString(clientId), new WString(authority), this.handle));
            if (!this.handle.isHandleValid()) {
                throw new MsalInteropException("MSALRUNTIME_CreateAuthParameters did not return an error but AuthParameters handle is invalid and cannot be used.", "msalruntime_error");
            }
            MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetRequestedScopes(this.handle.value(), new WString(scopes)));
        }

        public AuthParametersBuilder redirectUri(String redirectUri) {
            if (redirectUri != null) {
                MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetRedirectUri(this.handle.value(), new WString(redirectUri)));
            }
            return this;
        }

        public AuthParametersBuilder claims(String claims) {
            if (claims != null) {
                MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetDecodedClaims(this.handle.value(), new WString(claims)));
            }
            return this;
        }

        public AuthParametersBuilder popParameters(String httpMethod, URI uri, String nonce) {
            if (httpMethod == null || uri == null || uri.getHost() == null) {
                throw new MsalInteropException("HTTP method and URI host must be non-null", "msalinteropexception");
            }
            httpMethod = httpMethod.toUpperCase();
            String host = uri.getHost();
            String path = uri.getPath() != null ? uri.getPath() : "";
            nonce = nonce != null ? nonce : "";
            MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetPopParams(this.handle.value(), new WString(httpMethod), new WString(host), new WString(path), new WString(nonce)));
            return this;
        }

        public AuthParametersBuilder additionalParameters(Map<String, String> parameters) {
            if (parameters != null) {
                for (Map.Entry<String, String> param : parameters.entrySet()) {
                    MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_SetAdditionalParameter(this.handle.value(), new WString(param.getKey()), new WString(param.getValue())));
                }
            }
            return this;
        }

        public AuthParameters build() {
            return new AuthParameters(this);
        }
    }
}

