/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.AuthResult;
import com.microsoft.azure.javamsalruntime.AuthResultHandle;
import com.microsoft.azure.javamsalruntime.HandleBase;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeFuture;
import com.microsoft.azure.javamsalruntime.ReadAccountResult;
import com.microsoft.azure.javamsalruntime.ReadAccountResultHandle;
import com.microsoft.azure.javamsalruntime.SignOutResult;
import com.microsoft.azure.javamsalruntime.SignOutResultHandle;
import com.sun.jna.Callback;
import com.sun.jna.WString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Callbacks {
    private static final Logger LOG = LoggerFactory.getLogger(Callbacks.class);

    static void validateResult(HandleBase handle, Integer msalRuntimeFuturesKey) {
        if (!handle.isHandleValid()) {
            throw new MsalInteropException("Result handle sent to callback is invalid, cannot parse result.", "msalinterop_error");
        }
        if (MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey) == null) {
            throw new MsalInteropException("Future missing from msalRuntimeFutures table, cannot complete future.", "msalinterop_error");
        }
    }

    public static class LogCallback
    implements LogCallbackInterface {
        @Override
        public void callback(WString logMessage, Integer logLevel, Integer callbackData) {
            String indicateMsalRuntimeLog = "(MSALRuntime log) {}";
            try {
                switch (logLevel) {
                    case 1: {
                        LOG.trace(indicateMsalRuntimeLog, (Object)logMessage);
                        break;
                    }
                    case 2: {
                        LOG.debug(indicateMsalRuntimeLog, (Object)logMessage);
                        break;
                    }
                    case 3: {
                        LOG.info(indicateMsalRuntimeLog, (Object)logMessage);
                        break;
                    }
                    case 4: {
                        LOG.warn(indicateMsalRuntimeLog, (Object)logMessage);
                        break;
                    }
                    case 5: 
                    case 6: {
                        LOG.error(indicateMsalRuntimeLog, (Object)logMessage);
                        break;
                    }
                    default: {
                        LOG.debug("MSALRuntime log with no corresponding log level: {}", (Object)logMessage);
                        break;
                    }
                }
            }
            catch (Exception e) {
                try {
                    LOG.error("Exception during MSALRuntime log callback: {}", (Object)e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class ReadAccountResultCallback
    implements ReadAccountResultCallbackInterface {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(ReadAccountResultHandle readAccountResultHandle, Integer msalRuntimeFuturesKey) {
            try {
                LOG.info("Starting read account callback.");
                Callbacks.validateResult(readAccountResultHandle, msalRuntimeFuturesKey);
                LOG.info("Read account result valid, parsing result and completing future.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).complete(new ReadAccountResult(readAccountResultHandle));
            }
            catch (MsalInteropException msalInteropEx) {
                LOG.error("Could not complete future with read account result, completing with MsalInteropException.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).completeExceptionally(msalInteropEx);
            }
            catch (Exception e) {
                LOG.error("Could not complete future due to unknown exception, completing future with the exception.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).completeExceptionally(e);
            }
            finally {
                MsalRuntimeFuture.msalRuntimeFutures.remove(msalRuntimeFuturesKey);
            }
        }
    }

    public static class SignOutResultCallback
    implements SignOutResultCallbackInterface {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(SignOutResultHandle signOutResultHandle, Integer msalRuntimeFuturesKey) {
            try {
                LOG.info("Starting sign out result callback.");
                Callbacks.validateResult(signOutResultHandle, msalRuntimeFuturesKey);
                LOG.info("Sign out result valid, parsing result and completing future.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).complete(new SignOutResult(signOutResultHandle));
            }
            catch (MsalInteropException msalInteropEx) {
                LOG.error("Could not complete future with sign out result, completing with MsalInteropException.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).completeExceptionally(msalInteropEx);
            }
            catch (Exception e) {
                LOG.error("Could not complete future due to unknown exception, completing future with the exception.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).completeExceptionally(e);
            }
            finally {
                MsalRuntimeFuture.msalRuntimeFutures.remove(msalRuntimeFuturesKey);
            }
        }
    }

    static class AuthResultCallback
    implements AuthResultCallbackInterface {
        AuthResultCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(AuthResultHandle authResultHandle, Integer msalRuntimeFuturesKey) {
            try {
                LOG.info("Starting auth result callback.");
                Callbacks.validateResult(authResultHandle, msalRuntimeFuturesKey);
                LOG.info("Auth result valid, parsing result and completing future.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).complete(new AuthResult(authResultHandle));
            }
            catch (MsalInteropException msalInteropEx) {
                LOG.error("Could not complete future with auth result, completing with MsalInteropException.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).completeExceptionally(msalInteropEx);
            }
            catch (Exception e) {
                LOG.error("Could not complete future due to unknown exception, completing future with the exception.");
                MsalRuntimeFuture.msalRuntimeFutures.get(msalRuntimeFuturesKey).completeExceptionally(e);
            }
            finally {
                MsalRuntimeFuture.msalRuntimeFutures.remove(msalRuntimeFuturesKey);
            }
        }
    }

    static interface LogCallbackInterface
    extends Callback {
        public void callback(WString var1, Integer var2, Integer var3);
    }

    static interface SignOutResultCallbackInterface
    extends Callback {
        public void callback(SignOutResultHandle var1, Integer var2);
    }

    static interface ReadAccountResultCallbackInterface
    extends Callback {
        public void callback(ReadAccountResultHandle var1, Integer var2);
    }

    static interface AuthResultCallbackInterface
    extends Callback {
        public void callback(AuthResultHandle var1, Integer var2);
    }
}

