/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.Error;
import com.microsoft.azure.javamsalruntime.ErrorHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.microsoft.azure.javamsalruntime.MsalRuntimeResponseStatus;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHelper.class);

    ErrorHelper() {
    }

    void logUnknownErrorReleasingHandle(Exception e) {
        LOG.error("Exception when releasing MSALRuntime handle, this may lead to memory leaks: {}", (Object)e.getMessage());
    }

    void checkMsalRuntimeError(ErrorHandle handle) throws MsalInteropException {
        if (handle != null) {
            Error parsedError = new Error(handle);
            if (parsedError.isValidError) {
                throw new MsalInteropException(this.errorMessageWithContext(parsedError), "msalruntime_error");
            }
        }
    }

    String errorMessageWithContext(Error error) {
        switch (error.msalRuntimeResponseStatus) {
            case MSALRUNTIME_RESPONSE_STATUS_INTERACTIONREQUIRED: {
                return String.format("User interaction required, re-try this request using an interactive flow. Context: %s | Response status: %s | Tag: %s | Error code: %s", new Object[]{error.msalRuntimeContext, error.msalRuntimeResponseStatus, error.msalRuntimeTag, error.msalRuntimeErrorCode});
            }
            case MSALRUNTIME_RESPONSE_STATUS_NONETWORK: 
            case MSALRUNTIME_RESPONSE_STATUS_NETWORKTEMPORARILYUNAVAILABLE: {
                return String.format("Network unavailable, could not complete request. Context: %s | Response status: %s | Tag: %s | Error code: %s", new Object[]{error.msalRuntimeContext, error.msalRuntimeResponseStatus, error.msalRuntimeTag, error.msalRuntimeErrorCode});
            }
            case MSALRUNTIME_RESPONSE_STATUS_SERVERTEMPORARILYUNAVAILABLE: {
                return String.format("Server temporarily unavailable, could not complete request at this time. Context: %s | Response status: %s | Tag: %s | Error code: %s", new Object[]{error.msalRuntimeContext, error.msalRuntimeResponseStatus, error.msalRuntimeTag, error.msalRuntimeErrorCode});
            }
            case MSALRUNTIME_RESPONSE_STATUS_AUTHORITYUNTRUSTED: {
                return String.format("Authority is not trusted by MSALRuntime, will not perform request. Context: %s | Response status: %s | Tag: %s | Error code: %s", new Object[]{error.msalRuntimeContext, error.msalRuntimeResponseStatus, error.msalRuntimeTag, error.msalRuntimeErrorCode});
            }
            case MSALRUNTIME_RESPONSE_STATUS_ACCOUNTNOTFOUND: {
                return String.format("Account not found for client ID. Context: %s | Response status: %s | Tag: %s | Error code: %s", new Object[]{error.msalRuntimeContext, error.msalRuntimeResponseStatus, error.msalRuntimeTag, error.msalRuntimeErrorCode});
            }
        }
        return String.format("MSALRuntime exception: Context: %s | Response status: %s | Tag: %s | Error code: %s", new Object[]{error.msalRuntimeContext, error.msalRuntimeResponseStatus, error.msalRuntimeTag, error.msalRuntimeErrorCode});
    }

    boolean checkResponseStatus(ErrorHandle errorHandle, MsalRuntimeResponseStatus responseStatus) {
        IntByReference responseStatusRef = new IntByReference();
        Error.ignoreAndReleaseError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetStatus(errorHandle, responseStatusRef));
        if (responseStatus.status != responseStatusRef.getValue()) {
            LOG.warn("Unexpected response status from MSALRuntime. Expected: {} | Actual: {}", (Object)responseStatus.status, (Object)responseStatusRef.getValue());
        }
        return responseStatus.status == responseStatusRef.getValue();
    }
}

