/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.Account;
import com.microsoft.azure.javamsalruntime.AccountHandle;
import com.microsoft.azure.javamsalruntime.ErrorHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.microsoft.azure.javamsalruntime.ReadAccountResultHandle;
import com.sun.jna.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Structure.FieldOrder(value={"unused"})
public class ReadAccountResult
extends Structure {
    private static final Logger LOG = LoggerFactory.getLogger(ReadAccountResult.class);
    public int unused;
    private Account account;
    private ReadAccountResultHandle resultHandle;

    public ReadAccountResult(ReadAccountResultHandle readAccountResultHandle) {
        this.resultHandle = readAccountResultHandle;
        this.parseReadAccountResult();
    }

    public Account getAccount() {
        return this.account;
    }

    void parseReadAccountResult() {
        if (!this.resultHandle.isHandleValid()) {
            throw new MsalInteropException("Read account result handle was invalid, could not parse.", "msalruntime_error");
        }
        LOG.info("Checking read account result error.");
        ErrorHandle error = new ErrorHandle();
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetReadAccountError(this.resultHandle, error));
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(error);
        LOG.info("Parsing read account result.");
        this.parseAndSetAccount();
    }

    void parseAndSetAccount() {
        AccountHandle accountHandle = new AccountHandle();
        MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetReadAccount(this.resultHandle, accountHandle));
        this.account = new Account(accountHandle);
    }
}

